/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqProcessAttach2
extends EPDC_Request {
    private int _ReqProcessIndex;
    private EStdString _ReqProcessPath;
    private byte _dominantLanguage;
    private EStdString fViewOrder;
    private static final int FIXED_LENGTH = 12;

    EReqProcessAttach2(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._ReqProcessIndex = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._ReqProcessPath = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        dataInputStream.skipBytes(4);
        if (this.getEPDCVersion() > 305) {
            this._dominantLanguage = dataInputStream.readByte();
        }
        if (this.getEPDCEngineSession().isViewOrderSupported()) {
            dataInputStream.skipBytes(3);
            offset = dataInputStream.readInt();
            if (offset != 0) {
                this.fViewOrder = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
            }
        }
    }

    public EReqProcessAttach2(int processIndex, String processPath, byte dominantLanguage, EPDC_EngineSession engineSession, int[] viewOrder) {
        super(49, engineSession);
        this._ReqProcessIndex = processIndex;
        this._ReqProcessPath = new EStdString(processPath, engineSession);
        this._dominantLanguage = dominantLanguage;
        this.fViewOrder = this.initViewOrderRequest(viewOrder, engineSession);
    }

    @Override
    int getFixedLen() {
        if (this.getEPDCVersion() > 305) {
            return 12 + super.getFixedLen() + 1 + (this.getEPDCEngineSession().isViewOrderSupported() ? 7 : 0);
        }
        return 12 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqProcessAttach2.getTotalBytes(this._ReqProcessPath) + EReqProcessAttach2.getTotalBytes(this.fViewOrder);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        dataOutputStream.writeInt(this._ReqProcessIndex);
        offset += EReqProcessAttach2.writeOffsetOrZero(dataOutputStream, offset, this._ReqProcessPath);
        dataOutputStream.writeInt(0);
        if (this.getEPDCVersion() > 305) {
            dataOutputStream.writeByte(this._dominantLanguage);
        }
        if (this.getEPDCEngineSession().isViewOrderSupported()) {
            dataOutputStream.write(new byte[3]);
            if (this.fViewOrder != null) {
                EReqProcessAttach2.writeOffsetOrZero(dataOutputStream, offset, this.fViewOrder);
            } else {
                dataOutputStream.writeInt(0);
            }
        }
        if (this._ReqProcessPath != null) {
            this._ReqProcessPath.output(dataOutputStream);
        }
        if (this.fViewOrder != null) {
            this.fViewOrder.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Process_Index", this._ReqProcessIndex);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Process_Path", this._ReqProcessPath);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Dominant_Language", this._dominantLanguage);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Updated view order", this.fViewOrder);
    }

    @Override
    public String getDescription() {
        return "Attach to a process";
    }
}

