/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqProcessAttach
extends EPDC_Request {
    private EStdString _processId = null;
    private EStdString _processPath;
    private int _eventHandlerId;
    private byte _dominantLanguage;
    private EStdString fViewOrder;
    private static final int FIXED_LENGTH = 16;

    EReqProcessAttach(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offset;
        if (this.getEPDCVersion() < 308) {
            this._processId = new EStdString(Integer.toString(dataInputStream.readInt()), engineSession);
        } else {
            offset = dataInputStream.readInt();
            if (offset != 0) {
                this._processId = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
            }
        }
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._processPath = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        dataInputStream.skipBytes(4);
        this._eventHandlerId = dataInputStream.readInt();
        if (this.getEPDCVersion() > 305) {
            this._dominantLanguage = dataInputStream.readByte();
        }
        if (this.getEPDCEngineSession().isViewOrderSupported()) {
            dataInputStream.skipBytes(3);
            offset = dataInputStream.readInt();
            if (offset != 0) {
                this.fViewOrder = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
            }
        }
    }

    public EReqProcessAttach(String processId, String processPath, int eventHandlerID, byte dominantLanguage, EPDC_EngineSession engineSession, int[] viewOrder) {
        super(46, engineSession);
        if (processId != null) {
            this._processId = new EStdString(processId, engineSession);
        }
        if (processPath != null) {
            this._processPath = new EStdString(processPath, engineSession);
        }
        this._eventHandlerId = eventHandlerID;
        this._dominantLanguage = dominantLanguage;
        this.fViewOrder = this.initViewOrderRequest(viewOrder, engineSession);
    }

    @Override
    int getFixedLen() {
        if (this.getEPDCVersion() > 305) {
            return 16 + super.getFixedLen() + 1 + (this.getEPDCEngineSession().isViewOrderSupported() ? 7 : 0);
        }
        return 16 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        int total = 0;
        total += super.getVarLen() + EReqProcessAttach.getTotalBytes(this._processPath);
        if (this.getEPDCVersion() > 307) {
            total += EReqProcessAttach.getTotalBytes(this._processId) + EReqProcessAttach.getTotalBytes(this.fViewOrder);
        }
        return total;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        if (this.getEPDCVersion() < 308) {
            int pid = 0;
            if (this._processId != null) {
                String tempPid = this._processId.toString();
                try {
                    pid = Integer.parseInt(tempPid);
                }
                catch (NumberFormatException e) {
                    pid = 0;
                }
            }
            dataOutputStream.writeInt(pid);
        } else {
            offset += EReqProcessAttach.writeOffsetOrZero(dataOutputStream, offset, this._processId);
        }
        EReqProcessAttach.writeOffsetOrZero(dataOutputStream, offset, this._processPath);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this._eventHandlerId);
        if (this.getEPDCVersion() > 305) {
            dataOutputStream.writeByte(this._dominantLanguage);
        }
        if (this.getEPDCEngineSession().isViewOrderSupported()) {
            dataOutputStream.write(new byte[3]);
            if (this.fViewOrder != null) {
                EReqProcessAttach.writeOffsetOrZero(dataOutputStream, offset, this.fViewOrder);
            } else {
                dataOutputStream.writeInt(0);
            }
        }
        if (this.getEPDCVersion() > 307 && this._processId != null) {
            this._processId.output(dataOutputStream);
        }
        if (this._processPath != null) {
            this._processPath.output(dataOutputStream);
        }
        if (this.fViewOrder != null) {
            this.fViewOrder.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Process_ID", this._processId);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Process_Path", this._processPath);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Event_Handler_ID", this._eventHandlerId);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Dominant_Language", this._dominantLanguage);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Updated view order", this.fViewOrder);
    }

    @Override
    public String getDescription() {
        return "Attach to a process (305)";
    }
}

