/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqPreparePgm
extends EPDC_Request {
    private EStdString _ReqPgmName;
    private EStdString _ReqPgmParms;
    private EStdString _ReqCmdName;
    private EStdString _ReqCmdParms;
    private EStdString _ReqChildNames;
    private EStdString _ReqJobName;
    private EStdString _ReqHostAddress;
    private int _programType;
    private byte _languageSetting;
    private EStdString fViewOrder;
    private static final int FIXED_LENGTH = 40;

    EReqPreparePgm(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._ReqPgmName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._ReqPgmParms = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._ReqCmdName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._ReqCmdParms = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._ReqChildNames = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._ReqJobName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._ReqHostAddress = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        dataInputStream.skipBytes(4);
        this._programType = dataInputStream.readInt();
        if (this.getEPDCVersion() == 305) {
            dataInputStream.skipBytes(4);
        } else {
            this._languageSetting = dataInputStream.readByte();
            dataInputStream.skipBytes(3);
        }
        if (this.getEPDCEngineSession().isViewOrderSupported() && (offset = dataInputStream.readInt()) != 0) {
            this.fViewOrder = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public EReqPreparePgm(String pgmName, String arguments, String jobName, boolean runToMain, byte dominantLanguage, EPDC_EngineSession engineSession, int[] viewOrder) {
        super(30, engineSession);
        this._ReqPgmName = new EStdString(pgmName, engineSession);
        if (arguments != null && arguments.length() != 0) {
            this._ReqPgmParms = new EStdString(arguments, engineSession);
        }
        this._ReqCmdName = null;
        this._ReqCmdParms = null;
        this._ReqChildNames = null;
        if (jobName != null) {
            this._ReqJobName = new EStdString(jobName, engineSession);
        }
        this._programType = runToMain ? 0 : Integer.MIN_VALUE;
        this._languageSetting = dominantLanguage;
        this.fViewOrder = this.initViewOrderRequest(viewOrder, engineSession);
    }

    @Override
    int getFixedLen() {
        return 40 + super.getFixedLen() + (this.getEPDCEngineSession().isViewOrderSupported() ? 4 : 0);
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqPreparePgm.getTotalBytes(this._ReqPgmName) + EReqPreparePgm.getTotalBytes(this._ReqPgmParms) + EReqPreparePgm.getTotalBytes(this._ReqCmdName) + EReqPreparePgm.getTotalBytes(this._ReqCmdParms) + EReqPreparePgm.getTotalBytes(this._ReqChildNames) + EReqPreparePgm.getTotalBytes(this._ReqJobName) + EReqPreparePgm.getTotalBytes(this._ReqHostAddress) + EReqPreparePgm.getTotalBytes(this.fViewOrder);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        offset += EReqPreparePgm.writeOffsetOrZero(dataOutputStream, offset, this._ReqPgmName);
        offset += EReqPreparePgm.writeOffsetOrZero(dataOutputStream, offset, this._ReqPgmParms);
        offset += EReqPreparePgm.writeOffsetOrZero(dataOutputStream, offset, this._ReqCmdName);
        offset += EReqPreparePgm.writeOffsetOrZero(dataOutputStream, offset, this._ReqCmdParms);
        offset += EReqPreparePgm.writeOffsetOrZero(dataOutputStream, offset, this._ReqChildNames);
        offset += EReqPreparePgm.writeOffsetOrZero(dataOutputStream, offset, this._ReqJobName);
        offset += EReqPreparePgm.writeOffsetOrZero(dataOutputStream, offset, this._ReqHostAddress);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this._programType);
        if (this.getEPDCVersion() == 305) {
            EReqPreparePgm.writeOffsetOrZero(dataOutputStream, offset, null);
        } else {
            dataOutputStream.writeByte(this._languageSetting);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
        }
        if (this.getEPDCEngineSession().isViewOrderSupported()) {
            if (this.fViewOrder != null) {
                offset += EReqPreparePgm.writeOffsetOrZero(dataOutputStream, offset, this.fViewOrder);
            } else {
                dataOutputStream.writeInt(0);
            }
        }
        if (this._ReqPgmName != null) {
            this._ReqPgmName.output(dataOutputStream);
        }
        if (this._ReqPgmParms != null) {
            this._ReqPgmParms.output(dataOutputStream);
        }
        if (this._ReqCmdName != null) {
            this._ReqCmdName.output(dataOutputStream);
        }
        if (this._ReqCmdParms != null) {
            this._ReqCmdParms.output(dataOutputStream);
        }
        if (this._ReqChildNames != null) {
            this._ReqChildNames.output(dataOutputStream);
        }
        if (this._ReqJobName != null) {
            this._ReqJobName.output(dataOutputStream);
        }
        if (this._ReqHostAddress != null) {
            this._ReqHostAddress.output(dataOutputStream);
        }
        if (this.fViewOrder != null) {
            this.fViewOrder.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Debuggee_Name", this._ReqPgmName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Debugee_Args", this._ReqPgmParms);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Command_Name", this._ReqCmdName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Command_Args", this._ReqCmdParms);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Child_Process_Name", this._ReqChildNames);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Debug_Job_Name", this._ReqJobName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Not_supported_HostAddress", this._ReqHostAddress);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Program_type", this._programType);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Dominant_Language_setting", this._languageSetting);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Updated view order", this.fViewOrder);
    }

    @Override
    public boolean isValidAfterProgramTerminate() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Prepare program for debug";
    }
}

