/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqPointerDeref
extends EPDC_Request {
    private int _exprID;
    private int _exprTreeNode;

    EReqPointerDeref(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._exprID = this.getEPDCVersion() < 310 ? dataInputStream.readUnsignedShort() : dataInputStream.readInt();
        this._exprTreeNode = dataInputStream.readInt();
    }

    public EReqPointerDeref(int id, int treeNodeId, EPDC_EngineSession engineSession) {
        super(9, engineSession);
        this._exprID = id;
        this._exprTreeNode = treeNodeId;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        if (this.getEPDCVersion() < 310) {
            dataOutputStream.writeShort(this._exprID);
        } else {
            dataOutputStream.writeInt(this._exprID);
        }
        dataOutputStream.writeInt(this._exprTreeNode);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_Expression_ID", this._exprID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_ExprTree_NodeID", this._exprTreeNode);
    }

    @Override
    int getFixedLen() {
        if (this.getEPDCVersion() < 310) {
            return 6 + super.getFixedLen();
        }
        return 8 + super.getFixedLen();
    }

    @Override
    public String getDescription() {
        return "Pointer dereference";
    }
}

