/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqPlaybackOptions
extends EPDC_Structures {
    private static final int FIXED_LENGTH = 44;
    public static final char LIST_ITEM_SEPERATOR = ',';
    private int fId;
    private int fBoolValue;
    private EStdString fStringValue;

    private static String getStringFromList(String[] list) {
        if (list != null) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < list.length) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(list[i]);
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    public EReqPlaybackOptions(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fId = dataInputStream.readInt();
        this.fBoolValue = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset > 0) {
            this.fStringValue = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        dataInputStream.read(new byte[32]);
    }

    public EReqPlaybackOptions(EPDC_EngineSession engineSession, int id, boolean boolValue) {
        this(engineSession, id, boolValue, (String)null);
    }

    public EReqPlaybackOptions(EPDC_EngineSession engineSession, int id, boolean boolValue, String stringValue) {
        super(engineSession);
        this.fId = id;
        this.fBoolValue = boolValue ? 1 : 0;
        this.fStringValue = stringValue == null ? null : new EStdString(stringValue, engineSession);
    }

    public EReqPlaybackOptions(EPDC_EngineSession engineSession, int id, boolean boolValue, String[] list) {
        this(engineSession, id, boolValue, EReqPlaybackOptions.getStringFromList(list));
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 44;
    }

    private String getString() {
        return this.fStringValue != null ? this.fStringValue.toString() : null;
    }

    @Override
    int getVarLen() {
        int result = super.getVarLen();
        return result += EReqPlaybackOptions.getTotalBytes(this.fStringValue);
    }

    public boolean isSet() {
        return this.fBoolValue == 1;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.fId);
        dataOutputStream.write(this.fBoolValue);
        EReqPlaybackOptions.writeOffsetOrZero(dataOutputStream, this.getFixedLen(), this.fStringValue);
        dataOutputStream.write(new byte[32]);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Playback_Option_Id", this.fId);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Playback_Option_boolean", this.isSet());
        if (this.fStringValue != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Playback_Option_string", this.getString());
        }
    }

    @Override
    public String getDescription() {
        return "Playback options";
    }
}

