/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqPlaybackControl
extends EPDC_Request {
    private static final int FIXED_LENGTH = 40;
    private int _control;

    public EReqPlaybackControl(EPDC_EngineSession engineSession, int control) {
        super(236, engineSession);
        this._control = control;
    }

    EReqPlaybackControl(byte[] bytes, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(bytes, dataInputStream, engineSession);
        dataInputStream.read(new byte[4]);
        this._control = dataInputStream.readInt();
        dataInputStream.read(new byte[32]);
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 40;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.write(new byte[4]);
        dataOutputStream.writeInt(this._control);
        dataOutputStream.write(new byte[32]);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] CONTROL_TYPES = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "Playback Move Back"), new EPDC_DumpUtils.NameVal(2, "Playback Move Forward"), new EPDC_DumpUtils.NameVal(3, "Resume Debug")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Control", EPDC_DumpUtils.getAttrbuteName(CONTROL_TYPES, this._control));
    }

    @Override
    public String getDescription() {
        return "Playback control";
    }
}

