/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqPlaybackOptions;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqPlayback
extends EPDC_Request {
    private static final int FIXED_LENGTH = 52;
    private int fRequestType;
    private int fMemory;
    private EReqPlaybackOptions[] fOptions = new EReqPlaybackOptions[0];

    EReqPlayback(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        dataInputStream.skipBytes(4);
        this.fRequestType = dataInputStream.readInt();
        int numOptions = dataInputStream.readInt();
        this.fMemory = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            OffsetDataInputStream dis = new OffsetDataInputStream(byteBuffer, offset);
            int i = 0;
            while (i < numOptions) {
                this.fOptions[i] = new EReqPlaybackOptions(byteBuffer, dis, engineSession);
                ++i;
            }
        }
        dataInputStream.skipBytes(32);
    }

    EReqPlayback(EPDC_EngineSession engineSession, int requestType) {
        this(engineSession, requestType, 0, null);
    }

    EReqPlayback(EPDC_EngineSession engineSession, int requestType, int memory, EReqPlaybackOptions[] options) {
        super(235, engineSession);
        this.fRequestType = requestType;
        this.fMemory = memory;
        if (options != null) {
            this.fOptions = options;
        }
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 52;
    }

    @Override
    int getVarLen() {
        int result = super.getVarLen();
        EReqPlaybackOptions[] eReqPlaybackOptionsArray = this.fOptions;
        int n = this.fOptions.length;
        int n2 = 0;
        while (n2 < n) {
            EReqPlaybackOptions option = eReqPlaybackOptionsArray[n2];
            result += EReqPlayback.getTotalBytes(option);
            ++n2;
        }
        return result;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        dataOutputStream.write(new byte[4]);
        dataOutputStream.writeInt(this.fRequestType);
        dataOutputStream.writeInt(this.fOptions.length);
        dataOutputStream.writeInt(this.fMemory);
        if (this.fOptions.length == 0) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(offset);
        }
        dataOutputStream.write(new byte[32]);
        EReqPlaybackOptions[] eReqPlaybackOptionsArray = this.fOptions;
        int n = this.fOptions.length;
        int n2 = 0;
        while (n2 < n) {
            EReqPlaybackOptions option = eReqPlaybackOptionsArray[n2];
            option.output(dataOutputStream);
            ++n2;
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] PLAYBACK_REQUEST_TYPES = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "Start playback"), new EPDC_DumpUtils.NameVal(4, "Query playback"), new EPDC_DumpUtils.NameVal(3, "Update playback"), new EPDC_DumpUtils.NameVal(2, "Stop playback")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "RequestType", EPDC_DumpUtils.getAttrbuteName(PLAYBACK_REQUEST_TYPES, this.fRequestType));
        if (this.fRequestType == 1 || this.fRequestType == 3) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Memory", this.fMemory);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Playback Options");
            int i = 0;
            while (i < this.fOptions.length) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                this.fOptions[i].writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
    }

    @Override
    public String getDescription() {
        switch (this.fRequestType) {
            case 1: {
                return "Start playback";
            }
            case 2: {
                return "Stop playback";
            }
            case 3: {
                return "Update playback";
            }
            case 4: {
                return "Query playback";
            }
        }
        return "**unknown playback type**";
    }
}

