/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqPartSet
extends EPDC_Request {
    private int _partID;
    private int _viewID;
    private int _srcFileIndex;
    private EStdString _partFileName;
    private static final int FIXED_LENGTH = 12;

    public EReqPartSet(String newFileName, int partID, int viewNum, int fileIndex, EPDC_EngineSession engineSession) {
        super(36, engineSession);
        this._partFileName = new EStdString(newFileName, engineSession);
        this._partID = partID;
        this._viewID = viewNum;
        this._srcFileIndex = fileIndex;
    }

    EReqPartSet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._partFileName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._partID = dataInputStream.readUnsignedShort();
        this._viewID = dataInputStream.readUnsignedShort();
        this._srcFileIndex = dataInputStream.readInt();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        EReqPartSet.writeOffsetOrZero(dataOutputStream, this.getFixedLen() + super.getVarLen(), this._partFileName);
        dataOutputStream.writeShort(this._partID);
        dataOutputStream.writeShort(this._viewID);
        dataOutputStream.writeInt(this._srcFileIndex);
        if (this._partFileName != null) {
            this._partFileName.output(dataOutputStream);
        }
    }

    @Override
    int getFixedLen() {
        return 12 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqPartSet.getTotalBytes(this._partFileName);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Replacement_FileName", this._partFileName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Part_ID", this._partID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "View_Number", this._viewID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "File_Number", this._srcFileIndex);
    }

    @Override
    public String getDescription() {
        return "Update a part";
    }
}

