/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqPartOpen
extends EPDC_Request {
    private int _moduleID;
    private EStdString _partFileName;
    private static final int FIXED_LENGTH = 8;

    EReqPartOpen(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._moduleID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._partFileName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public EReqPartOpen(int id, String partName, EPDC_EngineSession engineSession) {
        super(17, engineSession);
        this._moduleID = id;
        this._partFileName = new EStdString(partName, engineSession);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._moduleID);
        int offset = this.getFixedLen() + super.getVarLen();
        EReqPartOpen.writeOffsetOrZero(dataOutputStream, offset, this._partFileName);
        if (this._partFileName != null) {
            this._partFileName.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Request_Module_ID", this._moduleID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Part_File_Name", this._partFileName);
    }

    @Override
    int getFixedLen() {
        return 8 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return EReqPartOpen.getTotalBytes(this._partFileName);
    }

    @Override
    public String getDescription() {
        return "Find a part";
    }
}

