/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqPartGet
extends EPDC_Request {
    private int _partID;
    private int _viewID;
    private int _srcFileIndex;
    private int _startLine;
    private int _numOfLines;
    private static final int FIXED_LENGTH = 16;

    EReqPartGet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._partID = dataInputStream.readUnsignedShort();
        this._viewID = dataInputStream.readUnsignedShort();
        this._srcFileIndex = dataInputStream.readInt();
        this._startLine = dataInputStream.readInt();
        this._numOfLines = dataInputStream.readInt();
    }

    public EReqPartGet(int partId, int viewId, int sourceFileIndex, int startLine, int numberOfLines, EPDC_EngineSession engineSession) {
        super(8, engineSession);
        this._partID = partId;
        this._viewID = viewId;
        this._srcFileIndex = sourceFileIndex;
        this._startLine = startLine;
        this._numOfLines = numberOfLines;
    }

    @Override
    int getFixedLen() {
        return 16 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this._partID);
        dataOutputStream.writeShort(this._viewID);
        dataOutputStream.writeInt(this._srcFileIndex);
        dataOutputStream.writeInt(this._startLine);
        dataOutputStream.writeInt(this._numOfLines);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Part_ID", this._partID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "View_ID", this._viewID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "File_Index", this._srcFileIndex);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Start_Line", this._startLine);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_of_lines", this._numOfLines);
    }

    @Override
    public String getDescription() {
        return "Get lines from a view file";
    }
}

