/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.IMultiRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class EReqMultiRequest
extends EPDC_Request
implements IMultiRequest {
    private ArrayList<EPDC_Request> fRequests = new ArrayList();
    private boolean fEnforceRequestType = false;

    EReqMultiRequest(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numRequests = dataInputStream.readInt();
        int i = 0;
        while (i < 16) {
            dataInputStream.readByte();
            ++i;
        }
        i = 0;
        while (i < numRequests) {
            dataInputStream.mark(8);
            dataInputStream.readInt();
            int packetLength = dataInputStream.readInt();
            dataInputStream.reset();
            EPDC_Request request = EPDC_Request.decodeRequestStream(dataInputStream, packetLength, engineSession);
            if (request != null) {
                this.fRequests.add(request);
            }
            ++i;
        }
    }

    public EReqMultiRequest(EPDC_EngineSession engineSession, boolean enforceRequestType) {
        super(241, engineSession);
        this.fEnforceRequestType = enforceRequestType;
    }

    public EReqMultiRequest(EPDC_EngineSession engineSession) {
        this(engineSession, true);
    }

    @Override
    public void addRequest(EPDC_Request request) {
        Assert.isTrue((this.fRequests.size() < 1024 ? 1 : 0) != 0, (String)"Maximum number of requests exceeded");
        Assert.isTrue((!this.fEnforceRequestType || this.fRequests.size() == 0 || request.getRequestCode() == this.fRequests.get(0).getRequestCode() ? 1 : 0) != 0, (String)"Request code does not match others in the multi-request");
        this.fRequests.add(request);
    }

    @Override
    public boolean isEmpty() {
        return this.fRequests.isEmpty();
    }

    @Override
    public int getNumRequests() {
        return this.fRequests.size();
    }

    @Override
    public void clearRequests() {
        this.fRequests.clear();
        this.setTotalBytes(0);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this.fRequests.size());
        int i = 0;
        while (i < 16) {
            dataOutputStream.writeByte(0);
            ++i;
        }
        for (EPDC_Request request : this.fRequests) {
            request.output(dataOutputStream);
        }
    }

    @Override
    int getFixedLen() {
        int fixedLen = 20;
        return fixedLen + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        int varLen = 0;
        for (EPDC_Request request : this.fRequests) {
            varLen += request.getTotalBytes();
        }
        return super.getVarLen() + varLen;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "numRequests", this.fRequests.size());
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Requests");
        int i = 0;
        while (i < this.fRequests.size()) {
            EPDC_Request request = this.fRequests.get(i);
            EPDC_DumpUtils.beginStructure(dataOutputStream, NLS.bind((String)"Requests[{0}]: {1} ({2})", (Object[])new Object[]{i, request.getDescription(), request.getRequestCode()}));
            EPDC_DumpUtils.startHeader(dataOutputStream);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "request_code", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "Remote_.*", request._request_code));
            EPDC_DumpUtils.writeVariable(dataOutputStream, "length", request.getTotalBytes());
            if (this.getEPDCVersion() > 310) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "threadID", request._threadID);
            }
            EPDC_DumpUtils.endHeader(dataOutputStream);
            request.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
            ++i;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "Multiple Requests";
    }

    @Override
    public EPDC_Request[] getRequests() {
        return this.fRequests.toArray(new EPDC_Request[this.fRequests.size()]);
    }
}

