/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EExtString;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqModuleSideFileUpdate
extends EPDC_Request {
    private EExtString _debugSideFileString;
    private int _moduleID;
    private static final int FIXED_LENGTH = 12;

    public EReqModuleSideFileUpdate(int moduleID, String sidefileLocation, EPDC_EngineSession engineSession) {
        super(234, engineSession);
        this._moduleID = moduleID;
        this._debugSideFileString = new EExtString(sidefileLocation, engineSession);
    }

    EReqModuleSideFileUpdate(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        dataInputStream.skipBytes(4);
        this._moduleID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._debugSideFileString = new EExtString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this._moduleID);
        EReqModuleSideFileUpdate.writeOffsetOrZero(dataOutputStream, offset, this._debugSideFileString);
        if (this._debugSideFileString != null) {
            this._debugSideFileString.output(dataOutputStream);
        }
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 12;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqModuleSideFileUpdate.getTotalBytes(this._debugSideFileString);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "moduleSideFile", this._debugSideFileString.toString());
    }

    @Override
    public String getDescription() {
        return "Update debug info location for module";
    }
}

