/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqModuleAdd
extends EPDC_Request {
    private EStdString _moduleName;
    private int _moduleType;
    private static final int FIXED_LENGTH = 8;

    public EReqModuleAdd(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
    }

    public EReqModuleAdd(String moduleName, int moduleType, EPDC_EngineSession engineSession) {
        super(52, engineSession);
        this._moduleName = new EStdString(moduleName, engineSession);
        this._moduleType = moduleType;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        EReqModuleAdd.writeOffsetOrZero(dataOutputStream, this.getFixedLen() + super.getVarLen(), this._moduleName);
        dataOutputStream.writeInt(this._moduleType);
        if (this._moduleName != null) {
            this._moduleName.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Module_Name", this._moduleName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Module_Type", this._moduleType);
    }

    @Override
    int getFixedLen() {
        return 8 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqModuleAdd.getTotalBytes(this._moduleName);
    }

    @Override
    public String getDescription() {
        return "Load a module";
    }
}

