/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EExtString;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class EReqLog
extends EPDC_Request {
    private EExtString _logString;
    private static final int FIXED_LENGTH = 8;

    EReqLog(int type, String cmd, EPDC_EngineSession engineSession) {
        super(type, engineSession);
        this._logString = new EExtString(cmd, engineSession);
        this._immediate = false;
    }

    EReqLog(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        dataInputStream.skipBytes(4);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._logString = new EExtString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        dataOutputStream.writeInt(0);
        EReqLog.writeOffsetOrZero(dataOutputStream, offset, this._logString);
        if (this._logString != null) {
            this._logString.output(dataOutputStream);
        }
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 8;
    }

    @Override
    int getVarLen() {
        return super.getVarLen() + EReqLog.getTotalBytes(this._logString);
    }

    public void setImmediate(boolean isImmediate) {
        this._immediate = isImmediate;
    }

    public String getLogString() {
        return this._logString.toString();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Command", this.getLogString());
    }
}

