/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqLocalVariableFree
extends EPDC_Request {
    private int _threadID;
    private static final int FIXED_LENGTH = 6;

    EReqLocalVariableFree(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._threadID = dataInputStream.readInt();
        dataInputStream.skipBytes(2);
    }

    public EReqLocalVariableFree(int threadID, EPDC_EngineSession engineSession) {
        super(41, engineSession);
        this._threadID = threadID;
    }

    @Override
    int getFixedLen() {
        return 6 + super.getFixedLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._threadID);
        dataOutputStream.writeShort(0);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread ID", this._threadID);
    }

    @Override
    public String getDescription() {
        return "Stop monitoring locals";
    }
}

