/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepGetNextStackEntry;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqLocalVariable
extends EPDC_Request {
    private int _threadID;
    private boolean _activeFiltersEnabled = false;
    private int[] _activeLocalFilters;
    private int _stackFrameID;
    private ERepGetNextStackEntry _stackEntry = null;

    EReqLocalVariable(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._threadID = dataInputStream.readInt();
        this._stackFrameID = dataInputStream.readUnsignedShort();
        this._activeFiltersEnabled = this.getEPDCEngineSession().supportsLocalFilters();
        if (this._activeFiltersEnabled) {
            int numFilters = dataInputStream.readUnsignedShort();
            int filterOffset = dataInputStream.readInt();
            this._activeLocalFilters = new int[numFilters];
            if (filterOffset != 0) {
                OffsetDataInputStream stream = new OffsetDataInputStream(byteBuffer, filterOffset);
                int i = 0;
                while (i < numFilters) {
                    this._activeLocalFilters[i] = stream.readInt();
                    ++i;
                }
                stream.close();
            }
        }
    }

    public EReqLocalVariable(int threadID, ERepGetNextStackEntry stackEntry, int[] activeLocalFilters, EPDC_EngineSession engineSession) {
        super(40, engineSession);
        this._threadID = threadID;
        this._stackEntry = stackEntry;
        this._activeFiltersEnabled = this.getEPDCEngineSession().supportsLocalFilters();
        this._activeLocalFilters = activeLocalFilters;
    }

    @Override
    int getFixedLen() {
        if (this._activeFiltersEnabled) {
            return 12 + super.getFixedLen();
        }
        return 6 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        if (this._activeFiltersEnabled) {
            return super.getVarLen() + 4 * this._activeLocalFilters.length;
        }
        return super.getVarLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._threadID);
        if (this._stackEntry == null) {
            dataOutputStream.writeShort(0);
        } else if (this.getEPDCVersion() > 308) {
            dataOutputStream.writeShort(this._stackEntry.getId());
        } else if (this.getEPDCEngineSession().useStackEntryIndex()) {
            dataOutputStream.writeShort(this._stackEntry.getIndex());
        } else {
            dataOutputStream.writeShort(this._stackEntry.getId());
        }
        if (this._activeFiltersEnabled) {
            dataOutputStream.writeShort(this._activeLocalFilters.length);
            if (this._activeLocalFilters.length == 0) {
                dataOutputStream.writeInt(0);
            } else {
                int offset = this.getFixedLen();
                dataOutputStream.writeInt(offset);
                int i = 0;
                while (i < this._activeLocalFilters.length) {
                    dataOutputStream.writeInt(this._activeLocalFilters[i]);
                    ++i;
                }
            }
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread ID", this._threadID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Stackframe ID", this._stackFrameID);
        if (this._activeFiltersEnabled) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Filter_List");
            int i = 0;
            while (i < this._activeLocalFilters.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._activeLocalFilters[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Filter_List", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Monitor local variables";
    }
}

