/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Locale;

public class EReqInitializeDE
extends EPDC_Request {
    private byte _debug_frontend_encoding;
    private int _debug_frontend_platform_id;
    private byte _language_setting;
    private EStdString _codePage;
    private EStdString _locale;
    private EStdString _filePrefix;
    private EStdString _DEArguments;
    private EStdString _remote_search_path;
    private byte _FEOptions = 0;
    private int _FEFCT = 0;
    private static final byte FEFCT_ENABLED = -128;
    private static final int FIXED_LENGTH = 31;

    public void setFEFCT(int fefct) {
        this._FEFCT = fefct;
        this._FEOptions = (byte)(this._FEOptions | 0xFFFFFF80);
    }

    public EReqInitializeDE(byte dominantLanguage, String productPrefix, String DEArguments, String remoteSearchPath, EPDC_EngineSession engineSession) {
        super(29, engineSession);
        this._debug_frontend_encoding = (byte)64;
        this._debug_frontend_platform_id = EReqInitializeDE.getPlatformIdentifier();
        this._language_setting = dominantLanguage;
        String codePage = System.getProperty("file.encoding");
        if (codePage == null) {
            codePage = "IBM-850";
        }
        this._codePage = new EStdString(codePage, engineSession);
        this._locale = new EStdString(Locale.getDefault().toString(), engineSession);
        if (productPrefix != null) {
            this._filePrefix = new EStdString(productPrefix, engineSession);
        }
        if (DEArguments != null) {
            this._DEArguments = new EStdString(DEArguments, engineSession);
        }
        if (remoteSearchPath != null) {
            this._remote_search_path = new EStdString(remoteSearchPath, engineSession);
        }
    }

    EReqInitializeDE(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._debug_frontend_encoding = dataInputStream.readByte();
        this._FEOptions = dataInputStream.readByte();
        dataInputStream.skipBytes(2);
        this._debug_frontend_platform_id = dataInputStream.readUnsignedShort();
        this._language_setting = dataInputStream.readByte();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._codePage = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._locale = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._filePrefix = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._DEArguments = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._remote_search_path = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._FEFCT = dataInputStream.readInt();
    }

    private String getFrontEndEncoding() {
        switch (this._debug_frontend_encoding) {
            case 64: {
                return "UTF8";
            }
        }
        return "UNKNOWN";
    }

    private String getFrontEndPlatform() {
        switch (this._debug_frontend_platform_id) {
            case 5: {
                return "AIX";
            }
            case 6: {
                return "Windows";
            }
            case 10: {
                return "Linux";
            }
            case 14: {
                return "macOS";
            }
        }
        return "UNKNOWN";
    }

    private String getDominantLanguageSetting() {
        switch (this._language_setting) {
            case 1: {
                return "C";
            }
            case 2: {
                return "CPP";
            }
            case 3: {
                return "PLX86";
            }
            case 4: {
                return "PLI";
            }
            case 5: {
                return "RPG";
            }
            case 6: {
                return "COBOL";
            }
            case 7: {
                return "ALP_ASM";
            }
            case 8: {
                return "OPM_RPG";
            }
            case 9: {
                return "CL_400";
            }
            case 10: {
                return "JAVA";
            }
            case 11: {
                return "FORTRAN";
            }
            case 17: {
                return "PL/X";
            }
            case 18: {
                return "GO";
            }
        }
        return "UNKNOWN";
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeByte(this._debug_frontend_encoding);
        dataOutputStream.writeByte(this._FEOptions);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeShort(this._debug_frontend_platform_id);
        if (this.getEPDCVersion() < 306) {
            dataOutputStream.writeByte(this._language_setting);
        } else {
            dataOutputStream.writeByte(0);
        }
        int offset = this.getFixedLen() + super.getVarLen();
        offset += EReqInitializeDE.writeOffsetOrZero(dataOutputStream, offset, this._codePage);
        offset += EReqInitializeDE.writeOffsetOrZero(dataOutputStream, offset, this._locale);
        offset += EReqInitializeDE.writeOffsetOrZero(dataOutputStream, offset, this._filePrefix);
        offset += EReqInitializeDE.writeOffsetOrZero(dataOutputStream, offset, this._DEArguments);
        EReqInitializeDE.writeOffsetOrZero(dataOutputStream, offset, this._remote_search_path);
        dataOutputStream.writeInt(this._FEFCT);
        if (this._codePage != null) {
            this._codePage.output(dataOutputStream);
        }
        if (this._locale != null) {
            this._locale.output(dataOutputStream);
        }
        if (this._filePrefix != null) {
            this._filePrefix.output(dataOutputStream);
        }
        if (this._DEArguments != null) {
            this._DEArguments.output(dataOutputStream);
        }
        if (this._remote_search_path != null) {
            this._remote_search_path.output(dataOutputStream);
        }
    }

    @Override
    int getFixedLen() {
        return 31 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return EReqInitializeDE.getTotalBytes(this._codePage) + EReqInitializeDE.getTotalBytes(this._locale) + EReqInitializeDE.getTotalBytes(this._filePrefix) + EReqInitializeDE.getTotalBytes(this._DEArguments) + EReqInitializeDE.getTotalBytes(this._remote_search_path) + super.getVarLen();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] FEFCTs = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Integer.MIN_VALUE, "Actions on breakpoints"), new EPDC_DumpUtils.NameVal(0x40000000, "Language sensitive local filters"), new EPDC_DumpUtils.NameVal(0x20000000, "Event content"), new EPDC_DumpUtils.NameVal(0x10000000, "Events on reply"), new EPDC_DumpUtils.NameVal(0x8000000, "Running Code Coverage"), new EPDC_DumpUtils.NameVal(0x4000000, "Dynamic Views Supported"), new EPDC_DumpUtils.NameVal(0x2000000, "Front End License Check Supported"), new EPDC_DumpUtils.NameVal(0x1000000, "Supports view order")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "FE_string_encoding", this.getFrontEndEncoding());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "FEOptions", (this._FEOptions & 0xFFFFFF80) != 0);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Front_End_Platform", this.getFrontEndPlatform());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "(Deprecated) Dominant_Language_setting", this.getDominantLanguageSetting());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Front_End_Code_page", this._codePage);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Locale_of_front_end", this._locale);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Prefix_characters", this._filePrefix);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "DE_Arguments", this._DEArguments);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Remote_Search_path", this._remote_search_path);
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "FE FCT flags", this._FEFCT, FEFCTs);
    }

    @Override
    public String getDescription() {
        return "Initialize the debug engine";
    }
}

