/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqGetList
extends EPDC_Request {
    private int _listType;
    private int _maxItems;
    private static final int FIXED_LENGTH = 6;

    public EReqGetList(int listType, int maxItems, EPDC_EngineSession engineSession) {
        super(233, engineSession);
        this._listType = listType;
        this._maxItems = maxItems;
    }

    EReqGetList(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._listType = dataInputStream.readUnsignedShort();
        this._maxItems = dataInputStream.readInt();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this._listType);
        dataOutputStream.writeInt(this._maxItems);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "listType", this._listType);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "maxItems", this._maxItems);
    }

    @Override
    int getFixedLen() {
        int total = 6 + super.getFixedLen();
        return total;
    }

    @Override
    int getVarLen() {
        return super.getVarLen();
    }

    public int getListType() {
        return this._listType;
    }

    @Override
    public String getDescription() {
        return "Get list";
    }
}

