/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.core.IPDTDebugConstants;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqGetFile
extends EPDC_Request {
    private final int fPartId;
    private final int fViewId;
    private final int fViewFileId;
    private int fStartPosn;
    private static final byte[] LINE_SEPARATOR_BYTES = IPDTDebugConstants.LINE_SEPARATOR.getBytes();

    public EReqGetFile(int partId, int viewId, int viewFileId, int startPosn, EPDC_EngineSession engineSession) {
        super(240, engineSession);
        this.fPartId = partId;
        this.fViewId = viewId;
        this.fViewFileId = viewFileId;
        this.fStartPosn = startPosn;
    }

    public EReqGetFile(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fPartId = dataInputStream.readInt();
        this.fViewId = dataInputStream.readInt();
        this.fViewFileId = dataInputStream.readInt();
        this.fStartPosn = dataInputStream.readInt();
    }

    public void setStartPosn(int startPosn) {
        this.fStartPosn = startPosn;
    }

    @Override
    public boolean isValidAfterProgramTerminate() {
        return true;
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 32;
    }

    @Override
    void output(DataOutputStream dis) throws IOException {
        super.output(dis);
        dis.writeInt(this.fPartId);
        dis.writeInt(this.fViewId);
        dis.writeInt(this.fViewFileId);
        dis.writeInt(this.fStartPosn);
        dis.writeInt(LINE_SEPARATOR_BYTES.length);
        if (LINE_SEPARATOR_BYTES.length == 1) {
            dis.writeByte(LINE_SEPARATOR_BYTES[0]);
            dis.writeByte(0);
        } else {
            dis.write(LINE_SEPARATOR_BYTES);
        }
        dis.write(new byte[10]);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Context", String.format("P:%d V:%d VF:%d", this.fPartId, this.fViewId, this.fViewFileId));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "StartPosn", this.fStartPosn);
        EPDC_DumpUtils.writeBytes(dataOutputStream, "line end", LINE_SEPARATOR_BYTES, 0);
    }

    @Override
    public String getDescription() {
        return "Get File Contents";
    }
}

