/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqExpressionValueModify
extends EPDC_Request {
    private int _exprID;
    private int _exprNodeID;
    private EStdString _newNodeValue;

    EReqExpressionValueModify(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._exprID = this.getEPDCVersion() < 310 ? dataInputStream.readUnsignedShort() : dataInputStream.readInt();
        this._exprNodeID = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._newNodeValue = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public EReqExpressionValueModify(int id, int nodeId, String value, EPDC_EngineSession engineSession) {
        super(7, engineSession);
        this._exprID = id;
        this._exprNodeID = nodeId;
        this._newNodeValue = new EStdString(value, engineSession);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        if (this.getEPDCVersion() < 310) {
            dataOutputStream.writeShort(this._exprID);
        } else {
            dataOutputStream.writeInt(this._exprID);
        }
        dataOutputStream.writeInt(this._exprNodeID);
        int offset = this.getFixedLen() + super.getVarLen();
        EReqExpressionValueModify.writeOffsetOrZero(dataOutputStream, offset, this._newNodeValue);
        if (this._newNodeValue != null) {
            this._newNodeValue.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_Modify_ID", this._exprID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_ExprTree_NodeID", this._exprNodeID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "New_Node_Value", this._newNodeValue);
    }

    @Override
    int getFixedLen() {
        if (this.getEPDCVersion() < 310) {
            return 10 + super.getFixedLen();
        }
        return 12 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return EReqExpressionValueModify.getTotalBytes(this._newNodeValue);
    }

    @Override
    public String getDescription() {
        return "Modify an expression";
    }
}

