/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqExpressionSubTreeDelete
extends EPDC_Request {
    private int _exprID;
    private int _exprTreeNodeID;
    private int _exprTreeStartChild;
    private int _exprTreeEndChild;

    EReqExpressionSubTreeDelete(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._exprID = this.getEPDCVersion() < 310 ? dataInputStream.readUnsignedShort() : dataInputStream.readInt();
        this._exprTreeNodeID = dataInputStream.readInt();
        this._exprTreeStartChild = dataInputStream.readInt();
        this._exprTreeEndChild = dataInputStream.readInt();
    }

    public EReqExpressionSubTreeDelete(int exprID, int exprTreeNodeID, int startChild, int endChild, EPDC_EngineSession engineSession) {
        super(38, engineSession);
        this._exprID = exprID;
        this._exprTreeNodeID = exprTreeNodeID;
        this._exprTreeStartChild = startChild;
        this._exprTreeEndChild = endChild;
    }

    @Override
    int getFixedLen() {
        if (this.getEPDCVersion() < 310) {
            return 14 + super.getFixedLen();
        }
        return 16 + super.getFixedLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        if (this.getEPDCVersion() < 310) {
            dataOutputStream.writeShort(this._exprID);
        } else {
            dataOutputStream.writeInt(this._exprID);
        }
        dataOutputStream.writeInt(this._exprTreeNodeID);
        dataOutputStream.writeInt(this._exprTreeStartChild);
        dataOutputStream.writeInt(this._exprTreeEndChild);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ExprID_ToModify", this._exprID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ExprTree_NodeID", this._exprTreeNodeID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ExprTree_StartChild", this._exprTreeStartChild);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ExprTree_EndChild", this._exprTreeEndChild);
    }

    @Override
    public String getDescription() {
        return "Collapse an expression node";
    }
}

