/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqExpressionRepTypeSet
extends EPDC_Request {
    private int _exprID;
    private int _nodeID;
    private int _newRepType;

    EReqExpressionRepTypeSet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._exprID = this.getEPDCVersion() < 310 ? dataInputStream.readUnsignedShort() : dataInputStream.readInt();
        this._nodeID = dataInputStream.readInt();
        this._newRepType = dataInputStream.readUnsignedShort();
    }

    public EReqExpressionRepTypeSet(int exprID, int nodeID, short nodeIndex, EPDC_EngineSession engineSession) {
        super(39, engineSession);
        this._exprID = exprID;
        this._nodeID = nodeID;
        this._newRepType = nodeIndex;
    }

    @Override
    int getFixedLen() {
        if (this.getEPDCVersion() < 310) {
            return 8 + super.getFixedLen();
        }
        return 10 + super.getFixedLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        if (this.getEPDCVersion() < 310) {
            dataOutputStream.writeShort(this._exprID);
        } else {
            dataOutputStream.writeInt(this._exprID);
        }
        dataOutputStream.writeInt(this._nodeID);
        dataOutputStream.writeShort(this._newRepType);
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ExprID_ToModify", this._exprID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ExprTree_NodeID", this._nodeID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ExprTree_NodeRepType", this._newRepType);
    }

    @Override
    public String getDescription() {
        return "Set representation";
    }
}

