/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqExpressionNodeAction
extends EPDC_Request {
    private int _monitorID;
    private int _nodeID;
    private int _actionID;

    public EReqExpressionNodeAction(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._monitorID = dataInputStream.readInt();
        this._nodeID = dataInputStream.readInt();
        this._actionID = dataInputStream.readUnsignedShort();
    }

    public EReqExpressionNodeAction(int monitorID, int nodeID, int actionID, EPDC_EngineSession engineSession) {
        super(74, engineSession);
        this._monitorID = monitorID;
        this._nodeID = nodeID;
        this._actionID = actionID;
    }

    @Override
    int getFixedLen() {
        return super.getFixedLen() + 10;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._monitorID);
        dataOutputStream.writeInt(this._nodeID);
        dataOutputStream.writeShort(this._actionID);
    }

    @Override
    int getVarLen() {
        return super.getVarLen();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor ID", this._monitorID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Node ID", this._nodeID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Action ID", this._actionID);
    }

    @Override
    public String getDescription() {
        return "Run action on expression node";
    }
}

