/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqExpression
extends EPDC_Request {
    private byte _monAttributes;
    private short _monType;
    private EStdExpression2 _expression = null;
    private EStdString _moduleName = null;
    private EStdString _partName = null;
    private EStdString _viewFileName = null;
    private EStdString _stmtNum = null;
    private static final int FIXED_LENGTH = 20;

    EReqExpression(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._monAttributes = dataInputStream.readByte();
        dataInputStream.skipBytes(1);
        this._monType = dataInputStream.readShort();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._expression = new EStdExpression2(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._moduleName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._partName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._viewFileName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._stmtNum = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public EReqExpression(byte attributes, short type, EStdExpression2 stdExpression, String moduleName, String partName, String viewFileName, String stmtNum, EPDC_EngineSession engineSession) {
        super(3, engineSession);
        this._monAttributes = attributes;
        this._monType = type;
        this._expression = stdExpression;
        if (moduleName != null) {
            this._moduleName = new EStdString(moduleName, engineSession);
        }
        if (partName != null) {
            this._partName = new EStdString(partName, engineSession);
        }
        if (viewFileName != null) {
            this._viewFileName = new EStdString(viewFileName, engineSession);
        }
        if (stmtNum != null) {
            this._stmtNum = new EStdString(stmtNum, engineSession);
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        int offset;
        super.output(dataOutputStream);
        dataOutputStream.writeByte(this._monAttributes);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeShort(this._monType);
        int exprOffset = offset = this.getFixedLen() + super.getVarLen();
        offset += EReqExpression.writeOffsetOrZero(dataOutputStream, offset, this._expression);
        offset += EReqExpression.writeOffsetOrZero(dataOutputStream, offset, this._moduleName);
        offset += EReqExpression.writeOffsetOrZero(dataOutputStream, offset, this._partName);
        offset += EReqExpression.writeOffsetOrZero(dataOutputStream, offset, this._viewFileName);
        if (this.getEPDCVersion() > 305) {
            EReqExpression.writeOffsetOrZero(dataOutputStream, offset, this._stmtNum);
        }
        if (this._expression != null) {
            this._expression.output(dataOutputStream, exprOffset);
        }
        if (this._moduleName != null) {
            this._moduleName.output(dataOutputStream);
        }
        if (this._partName != null) {
            this._partName.output(dataOutputStream);
        }
        if (this._viewFileName != null) {
            this._viewFileName.output(dataOutputStream);
        }
        if (this._stmtNum != null) {
            this._stmtNum.output(dataOutputStream);
        }
    }

    @Override
    int getVarLen() {
        int total = EReqExpression.getTotalBytes(this._expression) + EReqExpression.getTotalBytes(this._moduleName) + EReqExpression.getTotalBytes(this._partName) + EReqExpression.getTotalBytes(this._viewFileName) + super.getVarLen();
        if (this._stmtNum != null) {
            total += EReqExpression.getTotalBytes(this._stmtNum);
        }
        return total;
    }

    public EStdExpression2 getExpression() {
        return this._expression;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] monConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(-128, "Enable"), new EPDC_DumpUtils.NameVal(64, "Defer")};
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Monitor_Attributes", this._monAttributes, monConstants);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Monitor_Type_Requested", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "MonType.*", this._monType));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Module_Name", this._moduleName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Part_Name", this._partName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "File_Name", this._viewFileName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "StmtNum", this._stmtNum);
        if (this._expression != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "User_Requested_Expression");
            this._expression.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "User_Requested_Expression", "NULL");
        }
    }

    @Override
    int getFixedLen() {
        if (this.getEPDCVersion() > 305) {
            return 24 + super.getFixedLen();
        }
        return 20 + super.getFixedLen();
    }

    public boolean isPopup() {
        return this._monType == 2;
    }

    @Override
    public String getDescription() {
        return "Monitor an expression";
    }

    @Override
    public boolean isCancelOnTimeout() {
        return this.isPopup() && this.getEPDCEngineSession().supportsAsync();
    }
}

