/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqExceptionStatusChange
extends EPDC_Request {
    private int[] _exceptionStatusFlags;
    private static final int FIXED_LENGTH = 4;

    public EReqExceptionStatusChange(int[] exceptionStatusFlags, EPDC_EngineSession engineSession) {
        super(213, engineSession);
        this._exceptionStatusFlags = exceptionStatusFlags;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        int numExceptions = this._exceptionStatusFlags.length;
        dataOutputStream.writeInt(numExceptions);
        int i = 0;
        while (i < numExceptions) {
            dataOutputStream.writeInt(this._exceptionStatusFlags[i]);
            ++i;
        }
    }

    @Override
    int getFixedLen() {
        return 4 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        int total = 4 * this._exceptionStatusFlags.length;
        return total;
    }

    EReqExceptionStatusChange(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numExceptions = dataInputStream.readInt();
        this._exceptionStatusFlags = new int[numExceptions];
        int i = 0;
        while (i < numExceptions) {
            this._exceptionStatusFlags[i] = dataInputStream.readInt();
            ++i;
        }
    }

    public int[] getExceptionStatusFlags() {
        return this._exceptionStatusFlags;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        if (this._exceptionStatusFlags != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Exception_Status_Flags");
            int i = 0;
            while (i < this._exceptionStatusFlags.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._exceptionStatusFlags[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Exception_Status_Flags", "NULL");
        }
        if (this._exceptionStatusFlags != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Exceptions", this._exceptionStatusFlags.length);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Exceptions", 0);
        }
    }

    @Override
    public String getDescription() {
        return "Change exception status";
    }
}

