/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqEntrySearch
extends EPDC_Request {
    private int _partID;
    private int _entryID;
    private byte _caseInsensitive;
    private EStdString _entryName;
    private static final int FIXED_LENGTH = 11;

    public EReqEntrySearch(int partID, String entryName, int entryID, byte caseInsensitive, EPDC_EngineSession engineSession) {
        super(10, engineSession);
        this._partID = partID;
        if (entryName != null) {
            this._entryName = new EStdString(entryName, engineSession);
        }
        this._entryID = entryID;
        this._caseInsensitive = caseInsensitive;
    }

    EReqEntrySearch(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._partID = dataInputStream.readUnsignedShort();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._entryName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._entryID = dataInputStream.readInt();
        this._caseInsensitive = dataInputStream.readByte();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this._partID);
        int offset = this.getFixedLen() + super.getVarLen();
        EReqEntrySearch.writeOffsetOrZero(dataOutputStream, offset, this._entryName);
        dataOutputStream.writeInt(this._entryID);
        dataOutputStream.writeByte(this._caseInsensitive);
        if (this._entryName != null) {
            this._entryName.output(dataOutputStream);
        }
    }

    private boolean isCaseSensitive() {
        return this._caseInsensitive == 0;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "PartID", this._partID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "EntryName", this._entryName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "EntryID", this._entryID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "CaseInsensitive", this.isCaseSensitive());
    }

    @Override
    int getFixedLen() {
        return 11 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return EReqEntrySearch.getTotalBytes(this._entryName) + super.getVarLen();
    }

    @Override
    public String getDescription() {
        return "Find entry point";
    }
}

