/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqContextConvert
extends EPDC_Request {
    private EStdView _context;
    private int _viewNum;
    private static final int FIXED_LENGTH = 14;

    public EReqContextConvert(EStdView context, short viewNum, EPDC_EngineSession engineSession) {
        super(50, engineSession);
        this._context = context;
        this._viewNum = viewNum;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        this._context.output(dataOutputStream);
        dataOutputStream.writeShort(this._viewNum);
    }

    EReqContextConvert(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._context = new EStdView(dataInputStream);
        this._viewNum = dataInputStream.readUnsignedShort();
    }

    @Override
    int getFixedLen() {
        return 14 + super.getFixedLen();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "ViewNum", this._viewNum);
        if (this._context != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Context");
            this._context.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Context", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Convert context to another view";
    }
}

