/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EReqBreakpointLocation;
import com.ibm.debug.pdt.internal.epdc.IMultiRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;

public class EReqBreakpointMultiple
extends EPDC_Request
implements IMultiRequest {
    private ArrayList<EReqBreakpointLocation> fBreakpointRequests = new ArrayList();

    EReqBreakpointMultiple(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
    }

    public EReqBreakpointMultiple(EPDC_EngineSession engineSession) {
        super(1, engineSession);
    }

    @Override
    public void addRequest(EPDC_Request breakpoint) {
        Assert.isTrue((this.fBreakpointRequests.size() < 1024 ? 1 : 0) != 0, (String)"Maximum number of requests exceeded");
        this.fBreakpointRequests.add((EReqBreakpointLocation)breakpoint);
    }

    @Override
    public boolean isEmpty() {
        return this.fBreakpointRequests.isEmpty();
    }

    @Override
    public int getNumRequests() {
        return this.fBreakpointRequests.size();
    }

    @Override
    public void clearRequests() {
        this.fBreakpointRequests.clear();
        this.setTotalBytes(0);
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(6);
        dataOutputStream.writeInt(this.fBreakpointRequests.size());
        int offset = this.getFixedLen();
        for (EReqBreakpointLocation request : this.fBreakpointRequests) {
            dataOutputStream.writeInt(offset);
            offset += request.getTotalBytes();
        }
        for (EReqBreakpointLocation request : this.fBreakpointRequests) {
            request.output(dataOutputStream);
        }
    }

    @Override
    int getFixedLen() {
        int fixedLen = 6 + 4 * this.fBreakpointRequests.size();
        return fixedLen + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        int varLen = 0;
        for (EReqBreakpointLocation request : this.fBreakpointRequests) {
            varLen += request.getTotalBytes();
        }
        return super.getVarLen() + varLen;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
    }

    @Override
    public String getDescription() {
        return "Multiple breakpoints";
    }

    @Override
    public EPDC_Request[] getRequests() {
        return this.fBreakpointRequests.toArray(new EPDC_Request[this.fBreakpointRequests.size()]);
    }
}

