/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.IReqHasBreakpointId;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class EReqBreakpointLocation
extends EPDC_Request
implements IReqHasBreakpointId {
    private short _action;
    private short _type;
    private short _attr;
    private EStdString _varPtr;
    private EStdString _DLLNamePtr;
    private EStdString _sourceNamePtr;
    private EStdString _fileNamePtr;
    private EStdExpression2 _condition;
    private int _threadID;
    private int _bkpID;
    private int _entryID;
    private EStdView _location;
    private EStdString _stmtNum = null;
    private EStdString _engineData = null;
    private boolean _isEngineDataSupported = false;
    private EStdString _bkpAction = null;
    private boolean _isBrkActionSupported = false;
    private ArrayList<EReqBreakpointLocation> fRequests;
    private EEveryClause _everyClause;
    private static final int FIXED_LENGTH = 66;
    private int fNumRequests;

    EReqBreakpointLocation(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        this(byteBuffer, dataInputStream, engineSession, 0);
    }

    private EReqBreakpointLocation(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession, int parentOffset) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.init();
        this._action = dataInputStream.readShort();
        if (this._action == 6) {
            this.fNumRequests = dataInputStream.readInt();
            this.fRequests = new ArrayList();
            int i = 0;
            while (i < this.fNumRequests) {
                int offset = dataInputStream.readInt();
                this.fRequests.add(new EReqBreakpointLocation(Arrays.copyOfRange(byteBuffer, offset, byteBuffer.length), new OffsetDataInputStream(byteBuffer, offset), engineSession));
                ++i;
            }
        } else {
            this._type = dataInputStream.readShort();
            this._attr = dataInputStream.readShort();
            this._everyClause = new EEveryClause(dataInputStream);
            int offset = dataInputStream.readInt();
            if (offset != 0) {
                this._varPtr = new EStdString(new OffsetDataInputStream(byteBuffer, parentOffset + offset), engineSession);
            }
            if ((offset = dataInputStream.readInt()) != 0) {
                this._DLLNamePtr = new EStdString(new OffsetDataInputStream(byteBuffer, parentOffset + offset), engineSession);
            }
            if ((offset = dataInputStream.readInt()) != 0) {
                this._sourceNamePtr = new EStdString(new OffsetDataInputStream(byteBuffer, parentOffset + offset), engineSession);
            }
            if ((offset = dataInputStream.readInt()) != 0) {
                this._fileNamePtr = new EStdString(new OffsetDataInputStream(byteBuffer, parentOffset + offset), engineSession);
            }
            if ((offset = dataInputStream.readInt()) != 0) {
                this._condition = new EStdExpression2(byteBuffer, new OffsetDataInputStream(byteBuffer, parentOffset + offset), engineSession);
            }
            this._threadID = dataInputStream.readInt();
            this._bkpID = dataInputStream.readInt();
            this._entryID = dataInputStream.readInt();
            offset = dataInputStream.readInt();
            if (offset != 0) {
                this._stmtNum = new EStdString(new OffsetDataInputStream(byteBuffer, parentOffset + offset), engineSession);
            }
            this._location = new EStdView(dataInputStream);
            if (this.isEngineDataField() && (offset = dataInputStream.readInt()) != 0) {
                this._engineData = new EStdString(new OffsetDataInputStream(byteBuffer, parentOffset + offset), engineSession);
            }
            if (this.isBkpActionField() && (offset = dataInputStream.readInt()) != 0) {
                this._bkpAction = new EStdString(new OffsetDataInputStream(byteBuffer, parentOffset + offset), engineSession);
            }
        }
    }

    EReqBreakpointLocation(short action, short bkpType, short attr, EEveryClause clause, String addrOrExpr, String moduleName, String partName, String fileName, EStdExpression2 condition, int threadID, int bkpID, int entryID, String stmtNum, EStdView context, String engineData, String bkpAction, EPDC_EngineSession engineSession) {
        super(1, engineSession);
        this.init();
        this._action = action;
        this._type = bkpType;
        this._attr = attr;
        this._everyClause = clause;
        if (this._everyClause == null) {
            this._everyClause = new EEveryClause();
        }
        if (addrOrExpr != null) {
            this._varPtr = new EStdString(addrOrExpr, engineSession);
        }
        if (moduleName != null) {
            this._DLLNamePtr = new EStdString(moduleName, engineSession);
        }
        if (partName != null) {
            this._sourceNamePtr = new EStdString(partName, engineSession);
        }
        if (fileName != null) {
            this._fileNamePtr = new EStdString(fileName, engineSession);
        }
        this._condition = condition;
        this._threadID = threadID;
        this._bkpID = bkpID;
        this._entryID = entryID;
        if (stmtNum != null) {
            this._stmtNum = new EStdString(stmtNum, engineSession);
        }
        if ((this._location = context) == null) {
            this._location = EStdView.EMPTY_VIEW;
        }
        if (this.isEngineDataField() && engineData != null) {
            this._engineData = new EStdString(engineData, engineSession);
        }
        if (this.isBkpActionField() && bkpAction != null) {
            this._bkpAction = new EStdString(bkpAction, engineSession);
        }
    }

    @Override
    int getFixedLen() {
        int fixedLen = 66 + super.getFixedLen();
        if (this.isEngineDataField()) {
            fixedLen += 4;
        }
        if (this.isBkpActionField()) {
            fixedLen += 4;
        }
        return fixedLen;
    }

    @Override
    int getVarLen() {
        int total = super.getVarLen() + EReqBreakpointLocation.getTotalBytes(this._varPtr) + EReqBreakpointLocation.getTotalBytes(this._DLLNamePtr) + EReqBreakpointLocation.getTotalBytes(this._sourceNamePtr) + EReqBreakpointLocation.getTotalBytes(this._fileNamePtr) + EReqBreakpointLocation.getTotalBytes(this._condition);
        if (this._stmtNum != null) {
            total += EReqBreakpointLocation.getTotalBytes(this._stmtNum);
        }
        if (this.isEngineDataField()) {
            total += EReqBreakpointLocation.getTotalBytes(this._engineData);
        }
        if (this.isBkpActionField()) {
            total += EReqBreakpointLocation.getTotalBytes(this._bkpAction);
        }
        return total;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this._action);
        dataOutputStream.writeShort(this._type);
        dataOutputStream.writeShort(this._attr);
        this._everyClause.output(dataOutputStream);
        int offset = this.getFixedLen() + super.getVarLen();
        offset += EReqBreakpointLocation.writeOffsetOrZero(dataOutputStream, offset, this._varPtr);
        offset += EReqBreakpointLocation.writeOffsetOrZero(dataOutputStream, offset, this._DLLNamePtr);
        offset += EReqBreakpointLocation.writeOffsetOrZero(dataOutputStream, offset, this._sourceNamePtr);
        offset += EReqBreakpointLocation.writeOffsetOrZero(dataOutputStream, offset, this._fileNamePtr);
        int offset2 = offset;
        offset += EReqBreakpointLocation.writeOffsetOrZero(dataOutputStream, offset, this._condition);
        dataOutputStream.writeInt(this._threadID);
        dataOutputStream.writeInt(this._bkpID);
        dataOutputStream.writeInt(this._entryID);
        if (this.getEPDCVersion() > 305) {
            offset += EReqBreakpointLocation.writeOffsetOrZero(dataOutputStream, offset, this._stmtNum);
        } else {
            dataOutputStream.writeInt(0);
        }
        this._location.output(dataOutputStream);
        if (this.isEngineDataField()) {
            EReqBreakpointLocation.writeOffsetOrZero(dataOutputStream, offset, this._engineData);
        }
        if (this.isBkpActionField()) {
            EReqBreakpointLocation.writeOffsetOrZero(dataOutputStream, offset, this._bkpAction);
        }
        if (this._varPtr != null) {
            this._varPtr.output(dataOutputStream);
        }
        if (this._DLLNamePtr != null) {
            this._DLLNamePtr.output(dataOutputStream);
        }
        if (this._sourceNamePtr != null) {
            this._sourceNamePtr.output(dataOutputStream);
        }
        if (this._fileNamePtr != null) {
            this._fileNamePtr.output(dataOutputStream);
        }
        if (this._condition != null) {
            this._condition.output(dataOutputStream, offset2);
        }
        if (this._stmtNum != null && this.getEPDCVersion() > 305) {
            this._stmtNum.output(dataOutputStream);
        }
        if (this._engineData != null && this.isEngineDataField()) {
            this._engineData.output(dataOutputStream);
        }
        if (this._bkpAction != null && this.isBkpActionField()) {
            this._bkpAction.output(dataOutputStream);
        }
    }

    public void setEntryID(int entryID) {
        this._entryID = entryID;
    }

    public EStdView getBkpContext() {
        return this._location;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] attConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Short.MIN_VALUE, "BkpAttrEnable"), new EPDC_DumpUtils.NameVal(16384, "BkpAttrDefer"), new EPDC_DumpUtils.NameVal(8192, "BkpAttrCaseSensitive"), new EPDC_DumpUtils.NameVal(4096, "BkpAttrSearchAll"), new EPDC_DumpUtils.NameVal(2048, "BkpAttrAddressRange"), new EPDC_DumpUtils.NameVal(128, "BkpAttrSynchronous")};
        EPDC_DumpUtils.NameVal[] actionConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "SetBkp"), new EPDC_DumpUtils.NameVal(3, "ReplaceBkp"), new EPDC_DumpUtils.NameVal(6, "MultipleBkp")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint_Action", EPDC_DumpUtils.getAttrbuteName(actionConstants, this._action));
        if (this._action == 6) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Requests", this.fNumRequests);
            for (EReqBreakpointLocation request : this.fRequests) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Breakpoint request");
                request.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            }
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint_Type", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, ".*BkpType", this._type));
            EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Breakpoint_Attributes", this._attr, attConstants);
            if (this._everyClause != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "EveryFromTo_Clause");
                this._everyClause.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "EveryFromTo_Clause", "NULL");
            }
            EPDC_DumpUtils.writeVariable(dataOutputStream, "VarPtr", this._varPtr);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "DLLNamePtr", this._DLLNamePtr);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Source_NamePtr", this._sourceNamePtr);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "File_NamePtr", this._fileNamePtr);
            if (this._condition != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Conditional_Expression");
                this._condition.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Conditional_Expression", "NULL");
            }
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread ID", this._threadID);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint_ID", this._bkpID);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Entry_ID", this._entryID);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Statement_Number", this._stmtNum);
            if (this._location != null) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Context_Breakpoint");
                this._location.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
            } else {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Context_Breakpoint", "NULL");
            }
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Engine_Data", this._engineData);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint_Action", this._bkpAction);
        }
    }

    private final boolean isEngineDataField() {
        return this._isEngineDataSupported;
    }

    private final boolean isBkpActionField() {
        return this._isBrkActionSupported;
    }

    private void init() {
        this._isEngineDataSupported = this.getEPDCVersion() >= 308 && this.getEPDCEngineSession().supportsEngineBreakpoints() || this.getEPDCVersion() >= 310;
        this._isBrkActionSupported = this.getEPDCEngineSession().supportsBreakpointActions();
    }

    @Override
    public String getDescription() {
        return "Location breakpoint";
    }

    @Override
    public int getBkptId() {
        return this._bkpID;
    }
}

