/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EEveryClause;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdEnhancedWatchBPData;
import com.ibm.debug.pdt.internal.epdc.EStdEventBPData;
import com.ibm.debug.pdt.internal.epdc.EStdExpression2;
import com.ibm.debug.pdt.internal.epdc.EStdModuleLoadData;
import com.ibm.debug.pdt.internal.epdc.EStdOccurrenceBPData;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import com.ibm.debug.pdt.internal.epdc.EStdWatchBPData;
import com.ibm.debug.pdt.internal.epdc.EStdZeroAddressBPData;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqBreakpointEvent
extends EPDC_Request {
    private short _action;
    private short _type;
    private short _attr;
    private EEveryClause _clause = new EEveryClause();
    private EStdEventBPData fBrkData = null;
    private EStdString fModuleName = null;
    private EStdString fPartName = null;
    private EStdString fFileName = null;
    private EStdExpression2 _condition = null;
    private EStdString _bkpAction = null;
    private int _byteCount = 0;
    private EStdView _context = EStdView.EMPTY_VIEW;
    private int _threadID = 0;
    private int _bkpID = 0;
    private EStdString _address = null;

    public EReqBreakpointEvent(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._action = dataInputStream.readShort();
        this._type = dataInputStream.readShort();
        this._attr = dataInputStream.readShort();
        this._clause = new EEveryClause(dataInputStream);
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            switch (this._type) {
                case 5: {
                    this.fBrkData = new EStdModuleLoadData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession, false);
                    break;
                }
                case 12: {
                    this.fBrkData = new EStdModuleLoadData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession, true);
                    break;
                }
                case 6: {
                    this.fBrkData = new EStdWatchBPData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    break;
                }
                case 7: {
                    this.fBrkData = new EStdEnhancedWatchBPData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    break;
                }
                case 8: {
                    this.fBrkData = new EStdOccurrenceBPData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    break;
                }
                case 13: {
                    this.fBrkData = new EStdZeroAddressBPData(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                    break;
                }
            }
        }
        if (this.fBrkData == null && this._type == 13) {
            this.fBrkData = new EStdZeroAddressBPData(engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fModuleName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fPartName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fFileName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._condition = new EStdExpression2(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        this._byteCount = dataInputStream.readInt();
        this._context = new EStdView(dataInputStream);
        this._threadID = dataInputStream.readInt();
        this._bkpID = dataInputStream.readInt();
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._address = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if (this.getEPDCEngineSession().supportsBreakpointActions() && (offset = dataInputStream.readInt()) != 0) {
            this._bkpAction = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public EReqBreakpointEvent(short action, short bkpType, short attr, EEveryClause clause, int threadId, EStdEventBPData eventData, EPDC_EngineSession engineSession) {
        this(0, action, bkpType, attr, clause, threadId, eventData, engineSession);
    }

    public EReqBreakpointEvent(int replaceId, short action, short bkpType, short attr, EEveryClause clause, int threadId, EStdEventBPData eventData, EPDC_EngineSession engineSession) {
        super(35, engineSession);
        this._action = action;
        this._type = bkpType;
        this._attr = attr;
        if (action == 3) {
            this._bkpID = replaceId;
        }
        if (clause != null) {
            this._clause = clause;
        }
        this._threadID = threadId;
        this.fBrkData = eventData;
        if (eventData instanceof EStdWatchBPData) {
            EStdWatchBPData data = (EStdWatchBPData)eventData;
            this.fModuleName = data.getModuleName();
            this.fPartName = data.getPartName();
            this.fFileName = data.getFileName();
            this._condition = data.getConditionalExpr();
            this._byteCount = data.getByteCount();
            this._context = data.getContext();
            this._bkpAction = data.getAction();
            this._address = data.getRestoreAddress();
        } else if (eventData instanceof EStdEnhancedWatchBPData) {
            EStdEnhancedWatchBPData data = (EStdEnhancedWatchBPData)eventData;
            this._condition = data.getConditionalExpr();
            this._bkpAction = data.getAction();
            this._address = data.getRestoreAddress();
            this._context = data.getContext();
            this._byteCount = data.getByteCount();
        } else if (eventData instanceof EStdOccurrenceBPData) {
            EStdOccurrenceBPData data = (EStdOccurrenceBPData)eventData;
            this._bkpAction = data.getAction();
        } else if (eventData instanceof EStdZeroAddressBPData) {
            EStdZeroAddressBPData data = (EStdZeroAddressBPData)eventData;
            this._condition = data.getConditionalExpr();
            this._bkpAction = data.getAction();
        }
    }

    @Override
    int getVarLen() {
        int varLen = super.getVarLen() + EReqBreakpointEvent.getTotalBytes(this.fBrkData) + EReqBreakpointEvent.getTotalBytes(this.fModuleName) + EReqBreakpointEvent.getTotalBytes(this.fPartName) + EReqBreakpointEvent.getTotalBytes(this.fFileName) + EReqBreakpointEvent.getTotalBytes(this._condition) + EReqBreakpointEvent.getTotalBytes(this._address);
        if (this.getEPDCEngineSession().supportsBreakpointActions()) {
            varLen += EReqBreakpointEvent.getTotalBytes(this._bkpAction);
        }
        return varLen;
    }

    @Override
    int getFixedLen() {
        int fixedLen = 66 + super.getFixedLen();
        if (this.getEPDCEngineSession().supportsBreakpointActions()) {
            fixedLen += 4;
        }
        return fixedLen;
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        int offset;
        super.output(dataOutputStream);
        dataOutputStream.writeShort(this._action);
        dataOutputStream.writeShort(this._type);
        dataOutputStream.writeShort(this._attr);
        this._clause.output(dataOutputStream);
        int brkDataOffset = offset = this.getFixedLen() + super.getVarLen();
        offset += EReqBreakpointEvent.writeOffsetOrZero(dataOutputStream, offset, this.fBrkData);
        offset += EReqBreakpointEvent.writeOffsetOrZero(dataOutputStream, offset, this.fModuleName);
        offset += EReqBreakpointEvent.writeOffsetOrZero(dataOutputStream, offset, this.fPartName);
        offset += EReqBreakpointEvent.writeOffsetOrZero(dataOutputStream, offset, this.fFileName);
        int conditionOffset = offset;
        offset += EReqBreakpointEvent.writeOffsetOrZero(dataOutputStream, offset, this._condition);
        dataOutputStream.writeInt(this._byteCount);
        if (this._context == null) {
            EStdView.EMPTY_VIEW.output(dataOutputStream);
        } else {
            this._context.output(dataOutputStream);
        }
        dataOutputStream.writeInt(this._threadID);
        dataOutputStream.writeInt(this._bkpID);
        offset += EReqBreakpointEvent.writeOffsetOrZero(dataOutputStream, offset, this._address);
        if (this.getEPDCEngineSession().supportsBreakpointActions()) {
            EReqBreakpointEvent.writeOffsetOrZero(dataOutputStream, offset, this._bkpAction);
        }
        if (this.fBrkData != null) {
            this.fBrkData.output(dataOutputStream, brkDataOffset);
        }
        if (this.fModuleName != null) {
            this.fModuleName.output(dataOutputStream);
        }
        if (this.fPartName != null) {
            this.fPartName.output(dataOutputStream);
        }
        if (this.fFileName != null) {
            this.fFileName.output(dataOutputStream);
        }
        if (this._condition != null) {
            this._condition.output(dataOutputStream, conditionOffset);
        }
        if (this._address != null) {
            this._address.output(dataOutputStream);
        }
        if (this.getEPDCEngineSession().supportsBreakpointActions() && this._bkpAction != null) {
            this._bkpAction.output(dataOutputStream);
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] attConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(Short.MIN_VALUE, "BkpAttrEnable"), new EPDC_DumpUtils.NameVal(16384, "BkpAttrDefer"), new EPDC_DumpUtils.NameVal(8192, "BkpAttrCaseSensitive"), new EPDC_DumpUtils.NameVal(4096, "BkpAttrSearchAll"), new EPDC_DumpUtils.NameVal(2048, "BkpAddressRange"), new EPDC_DumpUtils.NameVal(128, "BkpAttrSynchronous")};
        EPDC_DumpUtils.NameVal[] actionConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "SetBkp"), new EPDC_DumpUtils.NameVal(3, "ReplaceBkp"), new EPDC_DumpUtils.NameVal(6, "MultipleBkp")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint_Action", EPDC_DumpUtils.getAttrbuteName(actionConstants, this._action));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint_Type", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, ".*BkpType", this._type));
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "Breakpoint_Attributes", this._attr, attConstants);
        EPDC_DumpUtils.beginStructure(dataOutputStream, this.fBrkData.getDescription());
        this.fBrkData.writeEPDC(dataOutputStream);
        EPDC_DumpUtils.endStructure(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "DLL_NamePtr", this.fModuleName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Source_NamePtr", this.fPartName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "File_NamePtr", this.fFileName);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Byte_Count", this._byteCount);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread_ID", this._threadID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint_ID", this._bkpID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Computed_Address", this._address);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint Action", this._bkpAction);
        if (this._clause != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, this._clause.getDescription());
            this._clause.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
        if (this._condition != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, this._condition.getDescription());
            this._condition.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
        if (this._context != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, this._context.getDescription());
            this._context.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        }
    }

    @Override
    public String getDescription() {
        return "Event breakpoint";
    }
}

