/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqBreakpointEntryAutoSet2
extends EPDC_Request {
    private int _enablementFlags;
    private static final int FIXED_LENGTH = 4;

    public EReqBreakpointEntryAutoSet2(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._enablementFlags = dataInputStream.readInt();
    }

    public EReqBreakpointEntryAutoSet2(boolean enableAutoSetEntryBreakpoints, boolean enableDateBreakpoints, EPDC_EngineSession engineSession) {
        super(51, engineSession);
        if (enableAutoSetEntryBreakpoints) {
            this._enablementFlags = 0x20000000;
        }
        if (enableDateBreakpoints) {
            this._enablementFlags |= 0x8000000;
        }
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._enablementFlags);
    }

    @Override
    int getFixedLen() {
        return 4 + super.getFixedLen();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] attrConstants = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(0x20000000, "AllEntryEnabled"), new EPDC_DumpUtils.NameVal(0x8000000, "DateEnabled")};
        EPDC_DumpUtils.writeFlagDetails(dataOutputStream, "SpecialBkpFlags", this._enablementFlags, attrConstants);
    }

    @Override
    public String getDescription() {
        return "Special breakpoints";
    }
}

