/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.IReqHasBreakpointId;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqBreakpointDisable
extends EPDC_Request
implements IReqHasBreakpointId {
    private int _bkpID;
    private static final int FIXED_LENGTH = 4;

    EReqBreakpointDisable(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._bkpID = dataInputStream.readInt();
    }

    public EReqBreakpointDisable(int id, EPDC_EngineSession engineSession) {
        super(33, engineSession);
        this._bkpID = id;
    }

    @Override
    int getFixedLen() {
        return 4 + super.getFixedLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._bkpID);
    }

    @Override
    public boolean isMatchingReply(EPDC_Reply reply) {
        if (this.getEPDCVersion() > 310) {
            return super.isMatchingReply(reply);
        }
        int replyCode = reply.getReplyCode();
        return replyCode == 33 || replyCode == 1;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Disable_BreakPoint_ID", this._bkpID);
    }

    @Override
    public String getDescription() {
        return "Disable breakpoint";
    }

    @Override
    public int getBkptId() {
        return this._bkpID;
    }
}

