/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.IReqHasBreakpointId;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EReqBreakpointClear
extends EPDC_Request
implements IReqHasBreakpointId {
    private int _bkpID;
    private static final int FIXED_LENGTH = 4;

    public EReqBreakpointClear(int bkpID, EPDC_EngineSession engineSession) {
        super(32, engineSession);
        this._bkpID = bkpID;
    }

    EReqBreakpointClear(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._bkpID = dataInputStream.readInt();
    }

    @Override
    int getFixedLen() {
        return 4 + super.getFixedLen();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._bkpID);
    }

    @Override
    public boolean isMatchingReply(EPDC_Reply reply) {
        if (this.getEPDCVersion() > 310) {
            return super.isMatchingReply(reply);
        }
        int replyCode = reply.getReplyCode();
        return replyCode == 32 || replyCode == 1;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Breakpoint ID", this._bkpID);
    }

    @Override
    public String getDescription() {
        return "Delete breakpoint";
    }

    @Override
    public int getBkptId() {
        return this._bkpID;
    }
}

