/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.EStdView;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class EReqAbstractExecute
extends EPDC_Request {
    private int _threadID;
    private byte _how;
    private EStdView _viewID;
    private int _numberSteps;
    private static final int FIXED_LENGTH = 10;
    private static final EPDC_DumpUtils.NameVal[] HOW_TYPES = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "Step debug"), new EPDC_DumpUtils.NameVal(2, "Step over"), new EPDC_DumpUtils.NameVal(3, "Step into"), new EPDC_DumpUtils.NameVal(4, "Step return"), new EPDC_DumpUtils.NameVal(5, "Resume"), new EPDC_DumpUtils.NameVal(6, "Examine exception"), new EPDC_DumpUtils.NameVal(7, "Jump to location"), new EPDC_DumpUtils.NameVal(8, "Run to location"), new EPDC_DumpUtils.NameVal(9, "Undo (not used)"), new EPDC_DumpUtils.NameVal(10, "Step exception"), new EPDC_DumpUtils.NameVal(11, "Run exception"), new EPDC_DumpUtils.NameVal(12, "Fork follow child"), new EPDC_DumpUtils.NameVal(13, "Fork follow parent"), new EPDC_DumpUtils.NameVal(14, "Fork follow both"), new EPDC_DumpUtils.NameVal(15, "Skip next")};

    EReqAbstractExecute(int threadID, byte how, EStdView stdView, EPDC_EngineSession engineSession) {
        super(2, engineSession);
        this._threadID = threadID;
        this._how = how;
        this._viewID = stdView;
        this._numberSteps = 1;
        this._immediate = false;
    }

    EReqAbstractExecute(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._threadID = dataInputStream.readInt();
        this._how = dataInputStream.readByte();
        dataInputStream.skipBytes(1);
        this._viewID = new EStdView(dataInputStream);
        this._numberSteps = dataInputStream.readInt();
    }

    @Override
    void output(DataOutputStream dataOutputStream) throws IOException {
        super.output(dataOutputStream);
        dataOutputStream.writeInt(this._threadID);
        dataOutputStream.writeByte(this._how);
        dataOutputStream.writeByte(0);
        this._viewID.output(dataOutputStream);
        dataOutputStream.writeInt(this._numberSteps);
    }

    @Override
    int getFixedLen() {
        return 22 + super.getFixedLen();
    }

    @Override
    int getVarLen() {
        return super.getVarLen();
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread", this._threadID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "How", EPDC_DumpUtils.getAttrbuteName(HOW_TYPES, this._how));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Nsteps", this._numberSteps);
        if (this._viewID != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "RView");
            this._viewID.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "RView", "NULL");
        }
    }

    public final int getThreadID() {
        return this._threadID;
    }

    public final byte getHow() {
        return this._how;
    }

    @Override
    public String getDescription() {
        EPDC_DumpUtils.NameVal[] nameValArray = HOW_TYPES;
        int n = HOW_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            EPDC_DumpUtils.NameVal howType = nameValArray[n2];
            if (howType.fVal == this._how) {
                return howType.fName;
            }
            ++n2;
        }
        return "*unknown*";
    }
}

