/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepViewSearchPath
extends EPDC_Reply {
    private String[] _filePaths = EMPTYSTRINGS;

    public ERepViewSearchPath(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numFilePaths = dataInputStream.readInt();
        OffsetDataInputStream dis = new OffsetDataInputStream(byteBuffer, dataInputStream.readInt());
        this._filePaths = new String[numFilePaths];
        int i = 0;
        while (i < this._filePaths.length) {
            this._filePaths[i] = new EStdString(dis, engineSession).toString();
            ++i;
        }
    }

    public int getNumFilePaths() {
        return this._filePaths.length;
    }

    public String[] getFilePaths() {
        return this._filePaths;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        if (this._filePaths.length > 0) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_File_Paths", this._filePaths.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "File_Path_Info");
            int i = 0;
            while (i < this._filePaths.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._filePaths[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_File_Paths", 0);
        }
    }

    @Override
    public String getDescription() {
        return "Search path for files";
    }
}

