/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepVersion
extends EPDC_Reply {
    static final int VERSION_OK = 0;
    static final int VERSION_ERROR = 1;
    static final int VERSION_RECONNECT = 2;
    static final int VERSION_AUTH_FAIL = 3;
    private int _debug_engine_version;
    private int _message_offset;
    private boolean fReconnect = false;
    int fVersionRC;

    ERepVersion(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, engineSession);
        this._reply_code = dataInputStream.readInt();
        this.setTotalBytes(dataInputStream.readInt());
        this._return_code = this.fVersionRC = dataInputStream.readInt();
        this._debug_engine_version = dataInputStream.readInt();
        if ((this._debug_engine_version < 305 || this._debug_engine_version > 999) && this._return_code == 1) {
            this._return_code = 0;
            this._debug_engine_version = 306;
        }
        if ((this._message_offset = dataInputStream.readInt()) != 0) {
            this._message_text = new EStdString(new OffsetDataInputStream(byteBuffer, this._message_offset), engineSession);
        }
        switch (this._return_code) {
            case 0: {
                break;
            }
            case 2: {
                this.fReconnect = true;
                this._return_code = 0;
                break;
            }
            default: {
                this._return_code = 332;
            }
        }
    }

    public int getVersion() {
        return this._debug_engine_version;
    }

    public int getVersionRC() {
        return this.fVersionRC;
    }

    public boolean isReconnect() {
        return this.fReconnect;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Engine EPDC version", this._debug_engine_version);
    }

    @Override
    public String getDescription() {
        return "EPDC version";
    }
}

