/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.ERepTypesAndRepsGetNext;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepTypesNumGet
extends EPDC_Reply {
    private static final ERepTypesAndRepsGetNext[] EMPTYTYPEREPS = new ERepTypesAndRepsGetNext[0];
    private ERepTypesAndRepsGetNext[] _types = EMPTYTYPEREPS;
    private static final int[] EMPTYREPS = EMPTYINTARRAY;

    public ERepTypesNumGet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numTypes = dataInputStream.readInt();
        this._types = new ERepTypesAndRepsGetNext[numTypes];
        if (numTypes == 1) {
            this._types[0] = new ERepTypesAndRepsGetNext(byteBuffer, dataInputStream, engineSession);
        } else {
            int i = 0;
            while (i < numTypes) {
                int offset = dataInputStream.readInt();
                if (offset != 0) {
                    this._types[i] = new ERepTypesAndRepsGetNext(byteBuffer, new OffsetDataInputStream(byteBuffer, offset), engineSession);
                }
                ++i;
            }
        }
    }

    public int getDefaultRepresentation(int typeIndex) {
        int i = 0;
        while (i < this._types.length) {
            ERepTypesAndRepsGetNext tar = this._types[i];
            if (tar.getTypeIndex() == typeIndex) {
                return tar.getDefaultRep();
            }
            ++i;
        }
        return 0;
    }

    public int[] getReps(int typeIndex) {
        int i = 0;
        while (i < this._types.length) {
            ERepTypesAndRepsGetNext tar = this._types[i];
            if (tar.getTypeIndex() == typeIndex) {
                return tar.getReps();
            }
            ++i;
        }
        return EMPTYREPS;
    }

    public ERepTypesAndRepsGetNext[] getTypes() {
        return this._types;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        ERepTypesAndRepsGetNext aType = null;
        if (this._types != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Types", this._types.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Types");
            int i = 0;
            while (i < this._types.length) {
                aType = this._types[i];
                aType.writeEPDC(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Types", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Types", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Get default reps for a language";
    }
}

