/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Structures;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepTypesAndRepsGetNext
extends EPDC_Structures {
    private int _typeIndex;
    private EStdString _typeName;
    private int _defaultRep;
    private int[] _reps;
    private static final int FIXED_LENGTH = 20;

    public ERepTypesAndRepsGetNext(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._typeIndex = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._typeName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        int numReps = dataInputStream.readInt();
        this._defaultRep = dataInputStream.readInt();
        this._reps = new int[numReps];
        OffsetDataInputStream offsetDataInputStream = new OffsetDataInputStream(byteBuffer, dataInputStream.readInt());
        int i = 0;
        while (i < numReps) {
            this._reps[i] = offsetDataInputStream.readInt();
            ++i;
        }
        offsetDataInputStream.close();
    }

    public String getTypeName() {
        if (this._typeName != null) {
            return this._typeName.toString();
        }
        return null;
    }

    public int getTypeIndex() {
        return this._typeIndex;
    }

    public int getDefaultRep() {
        return this._defaultRep;
    }

    public void setDefaultRep(int rep) {
        this._defaultRep = rep;
    }

    public int[] getReps() {
        return this._reps;
    }

    @Override
    int getFixedLen() {
        return 20;
    }

    @Override
    int getVarLen() {
        int total = 0;
        total += ERepTypesAndRepsGetNext.getTotalBytes(this._typeName);
        if (this._reps != null) {
            total += this._reps.length * 4;
        }
        return total;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Type_Index", this.getTypeIndex());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Type_Name", this.getTypeName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Default_Rep", this.getDefaultRep());
        if (this._reps != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Reps", this._reps.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Scalar_Reps");
            int i = 0;
            while (i < this._reps.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._reps[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Reps", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Scalar_Reps", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Default representations";
    }
}

