/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdStorageSegment;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepStorageGetBlock
extends EPDC_Reply {
    private static final EStdStorageSegment[] EMPTYSTORAGESEGMENT = new EStdStorageSegment[0];
    private int _numSegments;
    private EStdStorageSegment[] _storageSegments = EMPTYSTORAGESEGMENT;

    public ERepStorageGetBlock(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._numSegments = dataInputStream.readInt();
        int segmentOffset = dataInputStream.readInt();
        dataInputStream.skipBytes(16);
        if (this._numSegments == 0 || segmentOffset == 0) {
            return;
        }
        OffsetDataInputStream storageBuffer = new OffsetDataInputStream(byteBuffer, segmentOffset);
        this._storageSegments = new EStdStorageSegment[this._numSegments];
        int i = 0;
        while (i < this._numSegments) {
            this._storageSegments[i] = new EStdStorageSegment(byteBuffer, storageBuffer, engineSession);
            ++i;
        }
    }

    public EStdStorageSegment[] getStorageSegments() {
        return this._storageSegments;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "numSegments", this._numSegments);
        int n = 0;
        while (n < this._storageSegments.length) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "segment[" + n + "]");
            this._storageSegments[n].writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
            ++n;
        }
    }

    @Override
    public String getDescription() {
        return "Get block of storage";
    }
}

