/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepStorageConvertToAddress
extends EPDC_Reply {
    private EStdString _address;
    private int _addressSize;
    private byte _storageFormat;
    private static final byte STORAGE_BIG_ENDIAN = 0;
    private static final byte STORAGE_LITTLE_ENDIAN = 1;

    public ERepStorageConvertToAddress(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offset = dataInputStream.readInt();
        this._address = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        this._addressSize = dataInputStream.readUnsignedByte();
        this._storageFormat = dataInputStream.readByte();
        dataInputStream.skipBytes(10);
    }

    public String getAddress() {
        return this._address.toString();
    }

    public boolean isBigEndian() {
        return this._storageFormat == 0;
    }

    public boolean isLittleEndian() {
        return this._storageFormat == 1;
    }

    public int getAddressSize() {
        return this._addressSize;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Address", this.getAddress());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Address length", this._addressSize);
        if (this.isBigEndian()) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Endianess", "BIG_ENDIAN");
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Endianess", "LITTLE_ENDIAN");
        }
    }

    @Override
    public String getDescription() {
        return "Convert expression to address";
    }
}

