/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.ETraceProperty;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class ERepStartTrace2
extends EPDC_Reply {
    private static final ETraceProperty[] EMPTY_PROPERTIES = new ETraceProperty[0];
    private ETraceProperty[] fProperties = EMPTY_PROPERTIES;

    ERepStartTrace2(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int offset;
        int numProperties = dataInputStream.readInt();
        if (dataInputStream.skipBytes(16) != 16) {
            PDTCoreUtils.logString(this, "Error reading reserved bits in ERepStartTrace2.", 2);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this.fProperties = new ETraceProperty[numProperties];
            OffsetDataInputStream propertiesStream = new OffsetDataInputStream(byteBuffer, offset);
            int i = 0;
            while (i < numProperties) {
                this.fProperties[i] = new ETraceProperty(byteBuffer, propertiesStream, engineSession);
                ++i;
            }
        }
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        if (this.fProperties.length > 0) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Trace Properties");
            int i = 0;
            while (i < this.fProperties.length) {
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                this.fProperties[i].writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "numTraceProperties", 0);
        }
    }

    @Override
    public String getDescription() {
        return "Start Trace Recording";
    }

    public ETraceProperty[] getTraceProperties() {
        if (this.fProperties.length > 0) {
            return EMPTY_PROPERTIES;
        }
        return Arrays.copyOf(this.fProperties, this.fProperties.length);
    }
}

