/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.ERepGetStackColumns;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class ERepStackDetailsGet
extends EPDC_Reply {
    private ArrayList<ERepGetStackColumns> _columnInfo;
    private int[] _defaultColumnIds = EMPTYINTARRAY;

    ERepStackDetailsGet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int i;
        int numColumns = dataInputStream.readInt();
        this._columnInfo = new ArrayList();
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            OffsetDataInputStream offsetDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
            i = 0;
            while (i < numColumns) {
                this._columnInfo.add(new ERepGetStackColumns(byteBuffer, offsetDataInputStream, this.getEPDCEngineSession()));
                ++i;
            }
        }
        int numDefaultColumns = dataInputStream.readInt();
        this._defaultColumnIds = new int[numDefaultColumns];
        i = 0;
        while (i < numDefaultColumns) {
            this._defaultColumnIds[i] = dataInputStream.readInt();
            ++i;
        }
    }

    public ERepGetStackColumns[] getColumnInfo() {
        return this._columnInfo.toArray(new ERepGetStackColumns[this._columnInfo.size()]);
    }

    public int[] getDefaultColumnIds() {
        return this._defaultColumnIds;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        int i;
        ERepGetStackColumns aGroup = null;
        if (this._columnInfo != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Columns", this._columnInfo.size());
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Column_Info");
            i = 0;
            while (i < this._columnInfo.size()) {
                aGroup = this._columnInfo.get(i);
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                aGroup.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Columns", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Column_Info", "NULL");
        }
        if (this._defaultColumnIds != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Default_Columns", this._defaultColumnIds.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Default_Column_IDs");
            i = 0;
            while (i < this._defaultColumnIds.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._defaultColumnIds[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Default_Columns", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Default_Column_IDs", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Get stack details";
    }
}

