/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.ERepGetRegistersGroups;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepRegistersDetailsGet
extends EPDC_Reply {
    private static final ERepGetRegistersGroups[] EMPTYREGISTERGROUPS = new ERepGetRegistersGroups[0];
    private ERepGetRegistersGroups[] _registerGroups = EMPTYREGISTERGROUPS;
    private int[] _defaultGroupIds = EMPTYINTARRAY;

    ERepRegistersDetailsGet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int i;
        int numGroups = dataInputStream.readInt();
        this._registerGroups = new ERepGetRegistersGroups[numGroups];
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            OffsetDataInputStream offsetDataInputStream = new OffsetDataInputStream(byteBuffer, offset);
            i = 0;
            while (i < numGroups) {
                this._registerGroups[i] = new ERepGetRegistersGroups(byteBuffer, offsetDataInputStream, engineSession);
                ++i;
            }
        }
        int numDefaultGroups = dataInputStream.readInt();
        this._defaultGroupIds = new int[numDefaultGroups];
        i = 0;
        while (i < numDefaultGroups) {
            this._defaultGroupIds[i] = dataInputStream.readInt();
            ++i;
        }
    }

    public ERepGetRegistersGroups[] getRegisterGroups() {
        return this._registerGroups;
    }

    public int[] getDefaultGroupIds() {
        return this._defaultGroupIds;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        int i;
        ERepGetRegistersGroups aGroup = null;
        if (this._registerGroups != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Groups", this._registerGroups.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Group_Info");
            i = 0;
            while (i < this._registerGroups.length) {
                aGroup = this._registerGroups[i];
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Index[" + i + "]");
                aGroup.writeEPDC(dataOutputStream);
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Groups", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Group_Info", "NULL");
        }
        if (this._defaultGroupIds != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Default_Groups", this._defaultGroupIds.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Default_Group_IDs");
            i = 0;
            while (i < this._defaultGroupIds.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._defaultGroupIds[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Default_Groups", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Default_Group_IDs", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Get register details";
    }
}

