/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ERepAbstractExecute;
import com.ibm.debug.pdt.internal.epdc.EStdNameValuePair;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepPutEventContent
extends ERepAbstractExecute {
    private static final EStdNameValuePair[] EMPTYFIELDS = new EStdNameValuePair[0];
    private short fEventType;
    private EStdNameValuePair[] fFields;

    ERepPutEventContent(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this.fEventType = dataInputStream.readShort();
        dataInputStream.readShort();
        int numFields = dataInputStream.readInt();
        int offset = dataInputStream.readInt();
        if (numFields == 0) {
            this.fFields = EMPTYFIELDS;
        } else {
            this.fFields = new EStdNameValuePair[numFields];
            int i = 0;
            while (i < numFields) {
                OffsetDataInputStream os = new OffsetDataInputStream(byteBuffer, offset);
                this.fFields[i] = new EStdNameValuePair(byteBuffer, os, engineSession);
                offset += this.fFields[i].getTotalBytes();
                ++i;
            }
        }
    }

    public short getEventType() {
        return this.fEventType;
    }

    public EStdNameValuePair[] getFields() {
        return this.fFields;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        super.writeEPDC(dataOutputStream);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Event type", this.fEventType);
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Name Value pairs");
        EStdNameValuePair[] eStdNameValuePairArray = this.fFields;
        int n = this.fFields.length;
        int n2 = 0;
        while (n2 < n) {
            EStdNameValuePair pair = eStdNameValuePairArray[n2];
            pair.writeEPDC(dataOutputStream);
            ++n2;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "Return event fields";
    }
}

