/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepProcessListGet
extends EPDC_Reply {
    private static final String[][] EMPTYPROCESSES = new String[0][0];
    private String[][] _processes = EMPTYPROCESSES;
    private int _numColumns;

    public ERepProcessListGet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numProcesses = dataInputStream.readInt();
        int numColumns = dataInputStream.readInt();
        this._processes = new String[numProcesses][numColumns];
        DataInputStream saveDataInputStream = dataInputStream;
        int i = 0;
        while (i < numProcesses) {
            if (numProcesses > 1) {
                dataInputStream = new OffsetDataInputStream(byteBuffer, saveDataInputStream.readInt());
            }
            int j = 0;
            while (j < numColumns) {
                this._processes[i][j] = new EStdString(dataInputStream, engineSession).toString();
                ++j;
            }
            ++i;
        }
    }

    public String[][] getProcesses() {
        return this._processes;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Columns", this._numColumns);
        String[] aProcess = null;
        if (this._processes != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Processes", this._processes.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Processes");
            int i = 0;
            while (i < this._processes.length) {
                aProcess = this._processes[i];
                EPDC_DumpUtils.beginStructure(dataOutputStream, "Process[" + i + "]");
                int j = 0;
                while (j < aProcess.length) {
                    EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + j + "]", aProcess[j]);
                    ++j;
                }
                EPDC_DumpUtils.endStructure(dataOutputStream);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Number_Of_Processes", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Processes", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "List of processes";
    }
}

