/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ERepProcessStop;
import com.ibm.debug.pdt.internal.epdc.EStdDate;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdTime;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepProcessAttach
extends ERepProcessStop {
    private EStdTime _timestamp;
    private EStdDate _datestamp;
    private EStdString _QualifiedName;
    private EStdString _ProcessId;
    private EStdString _profileName;

    ERepProcessAttach(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._timestamp = new EStdTime(dataInputStream);
        this._datestamp = new EStdDate(dataInputStream);
        int offset = 0;
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._QualifiedName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        int tempPid = dataInputStream.readInt();
        if (this.getEPDCVersion() < 308) {
            this._ProcessId = new EStdString(Integer.toString(tempPid), engineSession);
        } else if (tempPid != 0) {
            this._ProcessId = new EStdString(new OffsetDataInputStream(byteBuffer, tempPid), engineSession);
        }
        this._threadID = dataInputStream.readInt();
        this._whyStop = dataInputStream.readShort();
        offset = dataInputStream.readInt();
        if (offset != 0) {
            this._exceptionMsg = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
        if ((offset = dataInputStream.readInt()) != 0) {
            this._profileName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public String getQualifiedName() {
        if (this._QualifiedName != null) {
            return this._QualifiedName.toString();
        }
        return null;
    }

    public String getTimeStamp() {
        if (this._timestamp == null) {
            return "";
        }
        return this._timestamp.toString();
    }

    public String getDateStamp() {
        if (this._datestamp == null) {
            return "";
        }
        return this._datestamp.toString();
    }

    public String getProcessId() {
        if (this._ProcessId == null) {
            return "";
        }
        return this._ProcessId.toString();
    }

    public String getProfileName() {
        if (this._profileName != null) {
            return this._profileName.toString();
        }
        return null;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Qualified_Name", this.getQualifiedName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Process_ID", this.getProcessId());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "DU", this.getThreadID());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Why_Stop", this.getWhyStop());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Exception_Message", this.getExceptionMsg());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Profile_Name", this.getProfileName());
        if (this._timestamp != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Time_Stamp");
            this._timestamp.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Time_Stamp", "NULL");
        }
        if (this._datestamp != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Date_Stamp");
            this._datestamp.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Date_Stamp", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Attach to a process";
    }
}

