/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ERepProcessStop;
import com.ibm.debug.pdt.internal.epdc.EStdDate;
import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.epdc.EStdTime;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import com.ibm.debug.pdt.internal.epdc.ProcessStopInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepPreparePgm
extends ERepProcessStop {
    private EStdTime _timestamp;
    private EStdDate _datestamp;
    private EStdString _MachineName;
    private EStdString _QualifiedName;
    private int _QualifiedNameOffset;
    private EStdString _ProcessId;
    private EStdString _profileName;
    private boolean fStopInfoComplete = false;

    ERepPreparePgm(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        this._timestamp = new EStdTime(dataInputStream);
        this._datestamp = new EStdDate(dataInputStream);
        dataInputStream.skipBytes(4);
        this._QualifiedNameOffset = dataInputStream.readInt();
        if (this._QualifiedNameOffset != 0) {
            this._QualifiedName = new EStdString(new OffsetDataInputStream(byteBuffer, this._QualifiedNameOffset), engineSession);
        }
        int tempProcessID = dataInputStream.readInt();
        if (this.getEPDCVersion() < 308) {
            this._ProcessId = new EStdString(Integer.toString(tempProcessID), engineSession);
        } else if (tempProcessID != 0) {
            this._ProcessId = new EStdString(new OffsetDataInputStream(byteBuffer, tempProcessID), engineSession);
        }
        int offset = dataInputStream.readInt();
        if (offset != 0) {
            this._profileName = new EStdString(new OffsetDataInputStream(byteBuffer, offset), engineSession);
        }
    }

    public String getQualifiedName() {
        if (this._QualifiedName != null) {
            return this._QualifiedName.toString();
        }
        return null;
    }

    public String getMachineName() {
        if (this._MachineName != null) {
            return this._MachineName.toString();
        }
        return null;
    }

    public String getProfileName() {
        if (this._profileName != null) {
            return this._profileName.toString();
        }
        return null;
    }

    public String getTimeStamp() {
        if (this._timestamp == null) {
            return "";
        }
        return this._timestamp.toString();
    }

    public String getDateStamp() {
        if (this._datestamp == null) {
            return "";
        }
        return this._datestamp.toString();
    }

    public String getProcessId() {
        if (this._ProcessId == null) {
            return "";
        }
        return this._ProcessId.toString();
    }

    @Override
    public void setStopInfo(ProcessStopInfo stopInfo) {
        if (!stopInfo.isExceptionMsgSet()) {
            stopInfo.setExceptionMsg(this.getMessageText());
        }
        this.fStopInfo = stopInfo;
        this.fStopInfoComplete = true;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Machine_Name", this.getMachineName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Qualified_Name", this.getQualifiedName());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Process_ID", this.getProcessId());
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Profile_Name", this.getProfileName());
        if (this._timestamp != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Time_Stamp");
            this._timestamp.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Time_Stamp", "NULL");
        }
        if (this._datestamp != null) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Date_Stamp");
            this._datestamp.writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Date_Stamp", "NULL");
        }
    }

    @Override
    public boolean isProgramTerminating() {
        if (this.fStopInfo == null) {
            return false;
        }
        return this.fStopInfo.isEnded();
    }

    @Override
    public boolean isStopInfoComplete() {
        return this.fStopInfoComplete;
    }

    @Override
    public String getDescription() {
        return "Prepare program";
    }
}

