/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ERepProcessStop;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepPlaybackControl
extends ERepProcessStop {
    private int _flags;
    private int _numSteps;
    private int _curStep;
    private int _threadID;
    private short _whyStop;

    ERepPlaybackControl(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        dataInputStream.read(new byte[4]);
        this._flags = dataInputStream.readInt();
        this._numSteps = dataInputStream.readInt();
        this._curStep = dataInputStream.readInt();
        dataInputStream.read(new byte[32]);
        this._threadID = dataInputStream.readInt();
        this._whyStop = dataInputStream.readShort();
    }

    public int getFlag() {
        return this._flags;
    }

    public int getNumberOfRecordedSteps() {
        return this._numSteps;
    }

    public int getCurrentStep() {
        return this._curStep;
    }

    @Override
    public int getThreadID() {
        return this._threadID;
    }

    @Override
    public short getWhyStop() {
        return this._whyStop;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.NameVal[] PLAYBACK_FLAGS = new EPDC_DumpUtils.NameVal[]{new EPDC_DumpUtils.NameVal(1, "At Resume Point"), new EPDC_DumpUtils.NameVal(3, "At beginning of history"), new EPDC_DumpUtils.NameVal(2, "At end of history")};
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Flag", EPDC_DumpUtils.getAttrbuteName(PLAYBACK_FLAGS, this._flags));
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Number of Steps", this._numSteps);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Current Step", this._curStep);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "Thread ID", this._threadID);
        EPDC_DumpUtils.writeVariable(dataOutputStream, "WhyStop", EPDC_DumpUtils.getAttrbuteName(IEPDCConstants.class, "Why_.*", this._whyStop));
    }

    @Override
    public String getDescription() {
        return "Playback control";
    }
}

