/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepPartOpen
extends EPDC_Reply {
    private int[] _partIDs = EMPTYINTARRAY;

    public ERepPartOpen(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numberOfParts = dataInputStream.readUnsignedShort();
        this._partIDs = new int[numberOfParts];
        int i = 0;
        while (i < numberOfParts) {
            this._partIDs[i] = dataInputStream.readUnsignedShort();
            ++i;
        }
    }

    public int[] getPartIDs() {
        return this._partIDs;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        if (this._partIDs != null) {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Parts", this._partIDs.length);
            EPDC_DumpUtils.beginStructure(dataOutputStream, "Part_ID");
            int i = 0;
            while (i < this._partIDs.length) {
                EPDC_DumpUtils.writeVariable(dataOutputStream, "Index[" + i + "]", this._partIDs[i]);
                ++i;
            }
            EPDC_DumpUtils.endStructure(dataOutputStream);
        } else {
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Num_Parts", 0);
            EPDC_DumpUtils.writeVariable(dataOutputStream, "Part_ID", "NULL");
        }
    }

    @Override
    public String getDescription() {
        return "Get part list from module";
    }
}

