/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.epdc;

import com.ibm.debug.pdt.internal.epdc.EPDC_DumpUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EStdSourceLine;
import com.ibm.debug.pdt.internal.epdc.OffsetDataInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ERepPartGet
extends EPDC_Reply {
    private static final EStdSourceLine[] EMPTYSOURCELINES = new EStdSourceLine[0];
    private EStdSourceLine[] _srcLines = EMPTYSOURCELINES;

    ERepPartGet(byte[] byteBuffer, DataInputStream dataInputStream, EPDC_EngineSession engineSession) throws IOException {
        super(byteBuffer, dataInputStream, engineSession);
        int numberOfLines = dataInputStream.readInt();
        this._srcLines = new EStdSourceLine[numberOfLines];
        if (numberOfLines == 1) {
            this._srcLines[0] = new EStdSourceLine(byteBuffer, dataInputStream, engineSession);
        } else {
            int i = 0;
            while (i < numberOfLines) {
                this._srcLines[i] = new EStdSourceLine(byteBuffer, new OffsetDataInputStream(byteBuffer, dataInputStream.readInt()), engineSession);
                ++i;
            }
        }
    }

    public EStdSourceLine[] getSourceLines() {
        return this._srcLines;
    }

    @Override
    public void writeEPDC(DataOutputStream dataOutputStream) throws IOException {
        EPDC_DumpUtils.beginStructure(dataOutputStream, "Source lines = " + this._srcLines.length);
        int i = 0;
        while (i < this._srcLines.length) {
            EPDC_DumpUtils.beginStructure(dataOutputStream, String.format("[%04d]%s%s", i, this._srcLines[i].isExecutable() ? "*" : " ", this._srcLines[i].getLineText()));
            this._srcLines[i].writeEPDC(dataOutputStream);
            EPDC_DumpUtils.endStructure(dataOutputStream);
            ++i;
        }
        EPDC_DumpUtils.endStructure(dataOutputStream);
    }

    @Override
    public String getDescription() {
        return "Get lines from view file";
    }
}

